/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.hoka.http.encoding.HTTPEncodingRegistry;
import ej.hoka.http.encoding.IHTTPEncodingHandler;
import ej.hoka.log.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class HTTPResponse {
    private static final String RESPONSE_COLON = ": ";
    private static final String RESPONSE_HTTP11 = "HTTP/1.1 ";
    private static final String RESPONSE_CONTENTTYPE = "content-type: ";
    private String status;
    private String mimeType;
    private Object data;
    private long length = -1L;
    private final HashMap<String, String> header = new HashMap(5);

    public HTTPResponse() {
        this(new byte[0]);
    }

    public HTTPResponse(byte[] data) {
        this.setData(data);
    }

    public HTTPResponse(InputStream data) {
        this.setData(data);
    }

    public HTTPResponse(InputStream data, int length) {
        this.setData(data);
        this.setLength(length);
    }

    public HTTPResponse(String data) {
        this(data == null ? new byte[]{} : data.getBytes());
    }

    public HTTPResponse(String data, String encoding) throws UnsupportedEncodingException {
        this(data == null ? new byte[]{} : data.getBytes(encoding));
    }

    public HTTPResponse(String status, String mimeType, InputStream body) {
        this(body);
        this.setStatus(status);
        this.setMimeType(mimeType);
    }

    public HTTPResponse(String status, String mimeType, String body) {
        this(body);
        this.setStatus(status);
        this.setMimeType(mimeType);
    }

    public static HTTPResponse createResponseFromStatus(String status) {
        return new HTTPResponse(status, null, "");
    }

    public void addHeaderField(String name, String value) {
        this.header.put(name, value);
    }

    public Map<String, String> getHeader() {
        return (Map)this.header.clone();
    }

    public String getHeaderField(String key) {
        if (key == null) {
            return null;
        }
        return this.header.get(key.toLowerCase());
    }

    protected long getLength() {
        return this.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getStatus() {
        return this.status;
    }

    private void setData(byte[] data) {
        byte[] result = data == null ? new byte[]{} : data;
        this.data = result;
        this.setLength(result.length);
    }

    private void setData(InputStream dataStream) {
        this.setData(dataStream, -1L);
    }

    private void setData(InputStream dataStream, long length) {
        this.data = dataStream;
        this.setLength(length);
    }

    private void setLength(long length) {
        if (length < 0L) {
            this.header.remove("content-length");
        } else {
            this.header.put("content-length", Long.toString(length));
        }
        this.length = length;
    }

    public final void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public final void setStatus(String status) {
        this.status = status;
    }

    void sendResponse(OutputStream outputStream, IHTTPEncodingHandler encodingHandler, HTTPEncodingRegistry encodingRegistry, int bufferSize) throws IOException {
        long length;
        if (encodingHandler != null) {
            this.addHeaderField("content-encoding", encodingHandler.getId());
        }
        if ((length = this.getLength()) < 0L) {
            this.addHeaderField("transfer-encoding", encodingRegistry.getChunkedTransferCodingHandler().getId());
        }
        this.writeHTTPHeader(outputStream);
        Object data = this.data;
        if (data instanceof byte[]) {
            byte[] dataArray = (byte[])data;
            this.sendRawDataResponse(dataArray, outputStream, encodingHandler, encodingRegistry);
        } else if (data != null) {
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream dataStream = (InputStream)data;){
                this.sendInputStreamResponse(dataStream, outputStream, encodingHandler, encodingRegistry, bufferSize);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        outputStream.flush();
    }

    private void sendRawDataResponse(byte[] rawData, OutputStream outputStream, IHTTPEncodingHandler encodingHandler, HTTPEncodingRegistry encodingRegistry) throws IOException {
        block19: {
            Throwable throwable = null;
            Object var6_7 = null;
            try (OutputStream dataOutput = encodingRegistry.getIdentityTransferCodingHandler().open(this, outputStream);){
                if (encodingHandler != null) {
                    Throwable throwable2 = null;
                    Object var9_12 = null;
                    try (OutputStream encodedDataOutput = encodingHandler.open(dataOutput);){
                        HTTPResponse.writeAndFlush(rawData, encodedDataOutput);
                        break block19;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                HTTPResponse.writeAndFlush(rawData, dataOutput);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private void sendInputStreamResponse(InputStream dataStream, OutputStream outputStream, IHTTPEncodingHandler encodingHandler, HTTPEncodingRegistry encodingRegistry, int bufferSize) {
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStream dataOutput = this.length == -1L ? encodingRegistry.getChunkedTransferCodingHandler().open(this, outputStream) : encodingRegistry.getIdentityTransferCodingHandler().open(this, outputStream);){
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (OutputStream ecodedOutput = encodingHandler != null ? encodingHandler.open(dataOutput) : null;){
                    int len;
                    OutputStream output = ecodedOutput != null ? ecodedOutput : dataOutput;
                    byte[] readBuffer = new byte[bufferSize];
                    while ((len = dataStream.read(readBuffer)) >= 0) {
                        output.write(readBuffer, 0, len);
                        output.flush();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            Messages.LOGGER.log('S', "Hoka", -255, t);
        }
    }

    private void writeHTTPHeader(OutputStream output) throws IOException {
        byte[] eofHeader = "\r\n".getBytes();
        output.write(RESPONSE_HTTP11.getBytes());
        output.write(this.getStatus().getBytes());
        output.write(32);
        output.write(eofHeader);
        if (this.mimeType != null) {
            output.write(RESPONSE_CONTENTTYPE.getBytes());
            output.write(this.mimeType.getBytes());
            output.write(eofHeader);
        }
        Map<String, String> header = this.getHeader();
        for (Map.Entry<String, String> entry : header.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            output.write(key.getBytes());
            output.write(RESPONSE_COLON.getBytes());
            output.write(value.getBytes());
            output.write(eofHeader);
        }
        output.write(eofHeader);
    }

    private static void writeAndFlush(byte[] data, OutputStream stream) throws IOException {
        stream.write(data);
        stream.flush();
        stream.close();
    }

    public static HTTPResponse createError(String status, String msg) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><head><title>");
        buffer.append(status);
        buffer.append("</title></head><body><h1>");
        buffer.append(status);
        buffer.append("</h1><p>");
        buffer.append(msg);
        buffer.append("</p></body></html>");
        HTTPResponse response = new HTTPResponse(buffer.toString());
        response.setMimeType("text/html");
        response.setStatus(status);
        return response;
    }
}

