/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.support;

import java.io.IOException;
import java.io.InputStream;

public final class UrlDecoder {
    private static final int HEXA = 16;

    private UrlDecoder() {
    }

    public static int decode(InputStream is, StringBuilder sb) throws IOException {
        return UrlDecoder.handleSurrogatePair(UrlDecoder.decodePercentage(is), sb);
    }

    private static int decodePercentage(InputStream is) throws IOException {
        boolean fourByte;
        boolean oneByte;
        int x = UrlDecoder.readEncodedCharacter(is, false);
        boolean bl = oneByte = x >>> 7 == 0;
        if (oneByte) {
            return x;
        }
        boolean twoByte = x >>> 5 == 6;
        boolean threeByte = x >>> 4 == 14;
        boolean bl2 = fourByte = x >>> 3 == 30;
        if (!(twoByte || threeByte || fourByte)) {
            throw new IllegalArgumentException();
        }
        int y = UrlDecoder.readEncodedCharacter(is, true);
        if (y >>> 6 != 2) {
            throw new IllegalArgumentException();
        }
        if (twoByte) {
            x = (x & 0x1F) << 6;
            return (y &= 0x3F) | x;
        }
        int z = UrlDecoder.readEncodedCharacter(is, true);
        if (z >>> 6 != 2) {
            throw new IllegalArgumentException();
        }
        if (threeByte) {
            y = (y & 0x3F) << 6;
            x = (x & 0xF) << 12;
            return (z &= 0x3F) | y | x;
        }
        int u = UrlDecoder.readEncodedCharacter(is, true);
        if (u >>> 6 != 2) {
            throw new IllegalArgumentException();
        }
        if (fourByte) {
            z = (z & 0x3F) << 6;
            y = (y & 0x3F) << 12;
            x = (x & 7) << 18;
            return (u &= 0x3F) | z | y | x;
        }
        throw new IllegalArgumentException();
    }

    private static int readEncodedCharacter(InputStream is, boolean readPercentageCharacter) throws IOException {
        int x;
        char percent;
        if (readPercentageCharacter && (percent = UrlDecoder.readChar(is)) != '%') {
            throw new IllegalArgumentException();
        }
        char c1 = UrlDecoder.readChar(is);
        char c2 = UrlDecoder.readChar(is);
        try {
            x = Character.digit(c1, 16) * 16 + Character.digit(c2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException();
        }
        return x;
    }

    private static char readChar(InputStream is) throws IOException {
        int i = is.read();
        if (i == -1) {
            throw new IOException();
        }
        return (char)i;
    }

    private static int handleSurrogatePair(int code, StringBuilder sb) {
        if (code > 65535) {
            int h = ((code -= 65536) >>> 10) + 55296;
            int l = (code & 0x3FF) + 56320;
            sb.append((char)h);
            code = l;
            return code;
        }
        return code;
    }
}

