/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.http.HTTPServer;
import ej.hoka.http.HTTPSession;
import ej.hoka.http.support.MIMEUtils;
import java.io.InputStream;

public class DefaultHTTPSession
extends HTTPSession {
    public DefaultHTTPSession(HTTPServer server) {
        super(server);
    }

    @Override
    public HTTPResponse answer(HTTPRequest request) {
        String uri = request.getURI();
        InputStream resourceStream = this.getClass().getResourceAsStream(uri);
        if (resourceStream == null) {
            HTTPResponse response = new HTTPResponse();
            response.setStatus("404 Not Found");
            return response;
        }
        HTTPResponse response = new HTTPResponse(resourceStream);
        response.setMimeType(MIMEUtils.getMIMEType(uri));
        response.setStatus("200 OK");
        return response;
    }

    public static class Factory
    implements HTTPSession.Factory {
        @Override
        public HTTPSession newHTTPSession(HTTPServer server) {
            return new DefaultHTTPSession(server);
        }
    }
}

