/*
 * Decompiled with CFR 0.152.
 */
package ej.property.loader;

import ej.annotation.Nullable;
import ej.property.PropertyLoader;
import ej.property.PropertyPermission;
import ej.service.loader.FilePropertiesServiceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FilePropertyLoader
implements PropertyLoader {
    private final String file;

    public FilePropertyLoader(String path) {
        this.file = path;
    }

    @Override
    @Nullable
    public String getProperty(String key) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String className = this.getClass().getSimpleName();
            securityManager.checkPermission(new PropertyPermission(className, key, "get"));
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = FilePropertiesServiceLoader.class.getResourceAsStream(this.file);){
                properties.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | NullPointerException exception) {}
        String property = properties.getProperty(key);
        if (property != null) {
            return property;
        }
        return null;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property = this.getProperty(key);
        if (property != null) {
            return property;
        }
        return defaultValue;
    }
}

