/*
 * Decompiled with CFR 0.152.
 */
package ej.storage.fs;

import ej.annotation.Nullable;
import ej.storage.Storage;
import ej.storage.fs.RandomAccessFileOutputStream;
import ej.storage.util.StorageHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class StorageFs
implements Storage {
    private static final String ROOT_PROPERTY_EXTENSION = ".root";
    private static final String DEFAULT_ROOT_FOLDER = "storage";
    private final File root;

    public StorageFs() throws IOException {
        this(StorageFs.getRootFolderPropertyOrDefault());
    }

    public StorageFs(String root) throws IOException {
        this.root = new File(root);
        if (this.root.exists() ? !this.root.isDirectory() : !this.root.mkdirs()) {
            throw new IOException();
        }
    }

    protected static String getRootFolderPropertyOrDefault() {
        return System.getProperty(String.valueOf(StorageFs.class.getName()) + ROOT_PROPERTY_EXTENSION, DEFAULT_ROOT_FOLDER);
    }

    public OutputStream store(String id) throws IOException {
        StorageHelper.checkID((String)id);
        return new FileOutputStream(this.getFile(id), false);
    }

    public OutputStream modify(String id, int offset) throws IOException {
        StorageHelper.checkID((String)id);
        StorageHelper.checkOffset((long)offset);
        return new RandomAccessFileOutputStream(this.getFile(id), offset);
    }

    protected File getFile(String id) {
        return new File(this.root, id);
    }

    public OutputStream append(String id) throws IOException {
        StorageHelper.checkID((String)id);
        return new FileOutputStream(this.getFile(id), true);
    }

    @Nullable
    public InputStream load(String id) throws IOException {
        StorageHelper.checkID((String)id);
        File file = this.getFile(id);
        if (file.exists() && file.isFile()) {
            return new FileInputStream(file);
        }
        return null;
    }

    public void move(String sourceId, String destinationId) throws IOException {
        StorageHelper.checkID((String)sourceId);
        StorageHelper.checkID((String)destinationId);
        File sourceFile = this.getFile(sourceId);
        if (sourceFile.exists()) {
            File destinationFile = this.getFile(destinationId);
            if (destinationFile.exists() && !destinationFile.delete()) {
                throw new IOException();
            }
            if (!sourceFile.renameTo(destinationFile)) {
                throw new IOException();
            }
        } else {
            throw new IOException();
        }
    }

    public void remove(String id) throws IOException {
        StorageHelper.checkID((String)id);
        File file = this.getFile(id);
        if (!file.delete()) {
            throw new IOException();
        }
    }

    public long getSize(String id) throws IOException {
        StorageHelper.checkID((String)id);
        File file = this.getFile(id);
        if (file.exists() && file.isFile()) {
            return file.length();
        }
        throw new IOException();
    }

    public boolean exists(String id) throws IOException {
        StorageHelper.checkID((String)id);
        File file = this.getFile(id);
        return file.isFile() && file.exists();
    }

    public String[] getIds() throws IOException {
        File[] files = this.root.listFiles();
        if (files == null) {
            throw new IOException();
        }
        ArrayList<String> idsList = new ArrayList<String>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (file.isFile()) {
                idsList.add(name);
            }
            ++n2;
        }
        return idsList.toArray(new String[idsList.size()]);
    }
}

