/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.io;

import java.io.IOException;
import java.io.InputStream;

public class IdentityMessageBodyInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 512;
    private boolean closed = false;
    private final InputStream is;
    private int remainingBytes;

    public IdentityMessageBodyInputStream(InputStream is, int bodyLength) {
        this.is = is;
        this.remainingBytes = bodyLength;
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.is.available(), this.remainingBytes);
    }

    private void checkPrematureEOF(int i) throws IOException {
        if (i == -1) {
            this.closed = true;
            throw new IOException();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.remainingBytes > 0) {
            byte[] buf = new byte[Math.min(512, this.remainingBytes)];
            while (this.remainingBytes > 0) {
                this.read(buf);
            }
        }
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (this.remainingBytes <= 0) {
            return -1;
        }
        int result = this.is.read();
        this.checkPrematureEOF(result);
        --this.remainingBytes;
        return result;
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (this.remainingBytes <= 0) {
            return -1;
        }
        int result = this.is.read(data, offset, Math.min(length, this.remainingBytes));
        this.checkPrematureEOF(result);
        this.remainingBytes -= result;
        return result;
    }
}

