/*
 * Decompiled with CFR 0.152.
 */
package org.json.me;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.me.JSONException;
import org.json.me.JSONObject;
import org.json.me.JSONTokener;

public class JSONArray
implements Iterable<Object> {
    private static final String IS_NOT_A = "is not a ";
    private static final String IS_NOT_A_STRING = "is not a string";
    private static final String IS_NOT_A_JSON_OBJECT = "is not a JSONObject";
    private static final String IS_NOT_A_JSON_ARRAY = "is not a JSONArray";
    private static final String IS_NOT_A_NUMBER = "is not a number";
    private static final String IS_NOT_A_BOOLEAN = "is not a boolean";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NOT_FOUND = "not found";
    private static final String JSON_ARRAY = "JSONArray[";
    private static final String EXPECTED_A_OR = "Expected a ',' or ']'";
    private static final String A_JSON_ARRAY_TEXT_MUST_START_WITH = "A JSONArray text must start with '['";
    private final ArrayList<Object> myArrayList = new ArrayList();

    public JSONArray() {
    }

    public JSONArray(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError(A_JSON_ARRAY_TEXT_MUST_START_WITH);
        }
        if (x.nextClean() != ']') {
            x.back();
            block4: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    this.myArrayList.add(JSONObject.NULL);
                } else {
                    x.back();
                    this.myArrayList.add(x.nextValue());
                }
                switch (x.nextClean()) {
                    case ',': {
                        if (x.nextClean() == ']') {
                            return;
                        }
                        x.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw x.syntaxError(EXPECTED_A_OR);
        }
    }

    public JSONArray(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONArray(Collection<?> collection) {
        if (collection != null) {
            for (Object o : collection) {
                this.myArrayList.add(JSONObject.wrap(o));
            }
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this.myArrayList.iterator();
    }

    public Object get(int index) throws JSONException {
        Object o = this.opt(index);
        if (o == null) {
            throw new JSONException(this.jsonArrayError(index, NOT_FOUND));
        }
        return o;
    }

    public boolean getBoolean(int index) throws JSONException {
        Object object = this.get(index);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase(FALSE)) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase(TRUE)) {
            return true;
        }
        throw new JSONException(this.jsonArrayError(index, IS_NOT_A_BOOLEAN));
    }

    public double getDouble(int index) throws JSONException {
        Object object = this.get(index);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            throw new JSONException(this.jsonArrayError(index, IS_NOT_A_NUMBER));
        }
    }

    public int getInt(int index) throws JSONException {
        return (int)this.getDouble(index);
    }

    public JSONArray getJSONArray(int index) throws JSONException {
        Object o = this.get(index);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException(this.jsonArrayError(index, IS_NOT_A_JSON_ARRAY));
    }

    public JSONObject getJSONObject(int index) throws JSONException {
        Object o = this.get(index);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException(this.jsonArrayError(index, IS_NOT_A_JSON_OBJECT));
    }

    public long getLong(int index) throws JSONException {
        return (long)this.getDouble(index);
    }

    public String getString(int index) throws JSONException {
        Object object = this.get(index);
        if (object instanceof String) {
            return (String)object;
        }
        throw new JSONException(this.jsonArrayError(index, IS_NOT_A_STRING));
    }

    public boolean isNull(int index) {
        return JSONObject.NULL.equals(this.opt(index));
    }

    public String join(String separator) throws JSONException {
        int len = this.length();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(JSONObject.valueToString(this.myArrayList.get(i)));
            ++i;
        }
        return sb.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.myArrayList.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(Collection<?> value) {
        this.put(new JSONArray(value));
        return this;
    }

    public JSONArray put(double value) throws JSONException {
        Double d = new Double(value);
        JSONObject.testValidity(d);
        this.put(d);
        return this;
    }

    public JSONArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    public JSONArray put(long value) {
        this.put(new Long(value));
        return this;
    }

    public JSONArray put(Map<?, ?> value) {
        this.put(new JSONObject(value));
        return this;
    }

    public JSONArray put(Object value) {
        this.myArrayList.add(value);
        return this;
    }

    public JSONArray put(int index, boolean value) throws JSONException {
        this.put(index, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int index, Collection<?> value) throws JSONException {
        this.put(index, new JSONArray(value));
        return this;
    }

    public JSONArray put(int index, double value) throws JSONException {
        this.put(index, new Double(value));
        return this;
    }

    public JSONArray put(int index, int value) throws JSONException {
        this.put(index, new Integer(value));
        return this;
    }

    public JSONArray put(int index, long value) throws JSONException {
        this.put(index, new Long(value));
        return this;
    }

    public JSONArray put(int index, Map<?, ?> value) throws JSONException {
        this.put(index, new JSONObject(value));
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public JSONArray put(int index, Object value) throws JSONException {
        block2: {
            JSONObject.testValidity(value);
            if (index < 0) {
                throw new JSONException(this.jsonArrayError(index, ""));
            }
            if (index >= this.length()) ** GOTO lbl10
            this.myArrayList.set(index, value);
            break block2;
lbl-1000:
            // 1 sources

            {
                this.put(JSONObject.NULL);
lbl10:
                // 2 sources

                ** while (index != this.length())
            }
lbl11:
            // 1 sources

            this.put(value);
        }
        return this;
    }

    public Object remove(int index) {
        return index >= 0 && index < this.length() ? this.myArrayList.remove(index) : null;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        int i = 0;
        while (i < names.length()) {
            jo.put(names.getString(i), this.opt(i));
            ++i;
        }
        return jo;
    }

    public String toString() {
        try {
            return String.valueOf('[') + this.join(",") + ']';
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws JSONException {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        if (len == 1) {
            sb.append(JSONObject.valueToString(this.myArrayList.get(0), indentFactor, indent));
        } else {
            int newindent = indent + indentFactor;
            sb.append('\n');
            int i = 0;
            while (i < len) {
                if (i > 0) {
                    sb.append(",\n");
                }
                int j = 0;
                while (j < newindent) {
                    sb.append(' ');
                    ++j;
                }
                sb.append(JSONObject.valueToString(this.myArrayList.get(i), indentFactor, newindent));
                ++i;
            }
            sb.append('\n');
            i = 0;
            while (i < indent) {
                sb.append(' ');
                ++i;
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean b = false;
            int len = this.length();
            writer.write(91);
            int i = 0;
            while (i < len) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.myArrayList.get(i)) instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v));
                }
                b = true;
                ++i;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private String jsonArrayError(int index, String end) {
        return JSON_ARRAY + index + "] " + end + ".";
    }
}

