/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.monitoring;

import ej.bon.Util;
import ej.kf.Kernel;
import java.util.logging.Logger;

public class CpuCalibration {
    private static final Logger LOGGER = Logger.getLogger(CpuCalibration.class.getName());
    private static final int CALIBRATION_PERIOD_MS = 120000;

    private CpuCalibration() {
    }

    public static void main(String[] args) {
        LOGGER.info("Starting CPU Calibration. Duration: 120 seconds");
        Kernel.getInstance().setExecutionQuota(Integer.MAX_VALUE);
        long start = System.currentTimeMillis();
        do {
            CpuCalibration.basicFibonacci();
        } while (Util.currentTimeMillis() - start <= 120000L);
        long effectiveDurationMS = Util.currentTimeMillis() - start;
        long counter = Kernel.getInstance().getExecutionCounter();
        long execCounterPerSecond = counter / (effectiveDurationMS / 1000L);
        LOGGER.info("Execution Counter per second: " + execCounterPerSecond);
        LOGGER.info("Calibration done.");
    }

    private static void basicFibonacci() {
        long a = 0L;
        long b = 1L;
        long n = 10L;
        int i = 0;
        while ((long)i < n) {
            long temp = a + b;
            a = b;
            b = temp;
            ++i;
        }
    }
}

