/*
 * Decompiled with CFR 0.152.
 */
package ej.util.concurrent;

import ej.annotation.Nullable;
import ej.bon.Util;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SingleThreadExecutor
implements Runnable,
ExecutorService {
    private final Thread thread = new Thread((Runnable)this, SingleThreadExecutor.class.getName());
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private boolean terminated;

    public SingleThreadExecutor() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isTerminated()) {
            Runnable active;
            Queue<Runnable> queue = this.tasks;
            synchronized (queue) {
                active = this.tasks.poll();
                if (active == null) {
                    try {
                        this.tasks.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (active == null) continue;
            active.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable r) {
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            this.tasks.offer(r);
            this.tasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.terminated = true;
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            this.tasks.notifyAll();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return this.terminated;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        RunnableFuture<T> ftask = this.newTaskFor(task);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    private <T> RunnableFuture<T> newTaskFor(final Callable<T> callable) {
        return new RunnableFuture<T>(){
            final Object lock = new Object();
            boolean isDone = false;
            @Nullable
            T result;
            @Nullable
            Exception exception;

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDone() {
                Object object = this.lock;
                synchronized (object) {
                    return this.isDone;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public T get() throws InterruptedException, ExecutionException {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.isDone()) {
                        this.lock.wait();
                    }
                }
                return this.getDone();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                long timeoutms = TimeUnit.MILLISECONDS.convert(timeout, unit);
                long start = Util.platformTimeMillis();
                Object object = this.lock;
                synchronized (object) {
                    while (!this.isDone()) {
                        long current = Util.platformTimeMillis();
                        long toWait = start + timeoutms - current;
                        if (toWait < 0L) {
                            throw new TimeoutException();
                        }
                        this.lock.wait(toWait);
                    }
                }
                return this.getDone();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Exception exception;
                Object result;
                try {
                    result = callable.call();
                    exception = null;
                }
                catch (Exception e) {
                    result = null;
                    exception = e;
                }
                Object object = this.lock;
                synchronized (object) {
                    this.result = result;
                    this.exception = exception;
                    this.isDone = true;
                    this.lock.notifyAll();
                }
            }

            @Nullable
            private T getDone() throws ExecutionException {
                Exception e = this.exception;
                if (e != null) {
                    throw new ExecutionException(e);
                }
                return this.result;
            }
        };
    }
}

