/*
 * Decompiled with CFR 0.152.
 */
package ej.observable;

import ej.observable.Observer;
import java.util.ArrayList;
import java.util.List;

public class Observable {
    private final List<Observer> observers = new ArrayList<Observer>();
    private boolean changed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer observer) throws NullPointerException {
        if (observer == null) {
            throw new NullPointerException();
        }
        List<Observer> list = this.observers;
        synchronized (list) {
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(Observer observer) {
        List<Observer> list = this.observers;
        synchronized (list) {
            this.observers.remove(observer);
        }
    }

    protected void setChanged() {
        this.changed = true;
    }

    protected void clearChanged() {
        this.changed = false;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public int countObservers() {
        return this.observers.size();
    }

    public void notifyObservers() {
        if (!this.changed) {
            return;
        }
        Observer[] observers = this.getObservers();
        this.clearChanged();
        for (Observer observer : observers) {
            observer.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Observer[] getObservers() {
        List<Observer> list = this.observers;
        synchronized (list) {
            return this.observers.toArray(new Observer[this.observers.size()]);
        }
    }
}

