/*
 * Decompiled with CFR 0.152.
 */
package ej.tool.addon.util;

import ej.tool.addon.util.DefaultMessageLogger;
import ej.tool.addon.util.MessageLogger;

public final class Message {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static MessageLogger defaultLogger = new DefaultMessageLogger(2);

    public static MessageLogger getDefaultLogger() {
        return defaultLogger;
    }

    public static void setDefaultLogger(MessageLogger logger) {
        defaultLogger = logger;
    }

    private static MessageLogger getLogger() {
        return defaultLogger;
    }

    public static void debug(String msg) {
        Message.getLogger().debug(msg);
    }

    public static void verbose(String msg) {
        Message.getLogger().verbose(msg);
    }

    public static void info(String msg) {
        Message.getLogger().info(msg);
    }

    public static void warn(String msg) {
        Message.getLogger().warn(msg);
    }

    public static void error(String msg) {
        Message.getLogger().error(msg);
    }

    public static void log(int logLevel, String msg) {
        switch (logLevel) {
            case 4: {
                Message.debug(msg);
                break;
            }
            case 3: {
                Message.verbose(msg);
                break;
            }
            case 2: {
                Message.info(msg);
                break;
            }
            case 1: {
                Message.warn(msg);
                break;
            }
            case 0: {
                Message.error(msg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level " + logLevel);
            }
        }
    }

    private Message() {
    }
}

