/*
 * Decompiled with CFR 0.152.
 */
package ej.basictool.map;

import ej.annotation.NonNull;
import ej.basictool.ArrayTools;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AbstractPackedMap<K, V> {
    @NonNull
    protected Object[] keysValues;

    public AbstractPackedMap() {
        this.keysValues = new Object[0];
    }

    public AbstractPackedMap(@NonNull AbstractPackedMap<K, V> map) {
        this.keysValues = (Object[])map.keysValues.clone();
    }

    public void clear() {
        this.keysValues = new Object[0];
    }

    public abstract Object clone();

    public boolean containsKey(@NonNull Object key) {
        return this.findExactIndex(this.keysValues, key) != -1;
    }

    public boolean containsValue(@NonNull Object value) {
        Object[] keysValues = this.keysValues;
        int keysValuesLength = keysValues.length;
        int size = keysValuesLength / 2;
        int i = size - 1;
        while (++i < keysValuesLength) {
            Object candidateValue = keysValues[i];
            if (!(candidateValue == null ? value == null : candidateValue.equals(value))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPackedMap other = (AbstractPackedMap)o;
        Object[] keysValues = this.keysValues;
        int size = keysValues.length / 2;
        if (other.size() != size) {
            return false;
        }
        int i = -1;
        while (++i < size) {
            K key = this.unwrapKey(keysValues[i]);
            if (!other.containsKey(key)) {
                return false;
            }
            Object value = keysValues[size + i];
            V otherValue = other.get(key);
            if (!(value == null ? otherValue != null : !value.equals(otherValue))) continue;
            return false;
        }
        return true;
    }

    public V get(@NonNull Object key) {
        Object[] keysValues = this.keysValues;
        int index = this.findExactIndex(keysValues, key);
        if (index == -1) {
            return null;
        }
        V value = AbstractPackedMap.getValue(keysValues, index);
        return value;
    }

    public int hashCode() {
        int hashCode = 0;
        Object[] keysValues = this.keysValues;
        int size = keysValues.length / 2;
        int i = 0;
        while (i < size) {
            hashCode += this.getWrappedKeyHashCode(keysValues[i]);
            ++i;
        }
        i = size;
        while (i < size * 2) {
            Object object = keysValues[i];
            hashCode += object != null ? object.hashCode() : 0;
            ++i;
        }
        return hashCode;
    }

    public boolean isEmpty() {
        return this.keysValues.length == 0;
    }

    @NonNull
    public Set<K> keySet() {
        return new PackedMapKeySet(this);
    }

    public V put(@NonNull K key, V value) {
        int hashCode = this.getKeyHashCode(key);
        int minIndex = 0;
        Object[] keysValues = this.keysValues;
        int keysLength = keysValues.length / 2;
        if (keysLength == 0) {
            this.keysValues = this.insertAt(keysValues, 0, key, value);
            return null;
        }
        int maxIndex = keysLength - 1;
        while (minIndex <= maxIndex) {
            int currentIndex = (maxIndex - minIndex) / 2 + minIndex;
            int candidateHashCode = this.getWrappedKeyHashCode(keysValues[currentIndex]);
            if (hashCode == candidateHashCode) {
                int index = this.linearSearchSameHashCode(keysValues, key, hashCode, currentIndex);
                if (index != -1) {
                    return this.replaceAt(keysValues, index, value);
                }
                minIndex = currentIndex;
                break;
            }
            if (hashCode > candidateHashCode) {
                minIndex = currentIndex + 1;
                continue;
            }
            maxIndex = currentIndex - 1;
        }
        this.keysValues = this.insertAt(keysValues, minIndex, key, value);
        return null;
    }

    @NonNull
    private Object[] insertAt(@NonNull Object[] keysValues, int index, @NonNull K key, V value) {
        int arrayLength = keysValues.length;
        Object[] newArray = new Object[arrayLength + 2];
        newArray[index] = this.wrapKey(key);
        int valueIndex = AbstractPackedMap.getValueIndex(newArray, index);
        newArray[valueIndex] = value;
        System.arraycopy(keysValues, 0, newArray, 0, index);
        System.arraycopy(keysValues, index, newArray, index + 1, valueIndex - index - 1);
        System.arraycopy(keysValues, valueIndex - 1, newArray, valueIndex + 1, arrayLength - valueIndex + 1);
        return newArray;
    }

    private V replaceAt(@NonNull Object[] keysValues, int index, V value) {
        int valueIndex = AbstractPackedMap.getValueIndex(keysValues, index);
        Object oldValue = keysValues[valueIndex];
        keysValues[valueIndex] = value;
        return (V)oldValue;
    }

    protected int getKeyHashCode(@NonNull Object key) {
        return key.hashCode();
    }

    protected int getWrappedKeyHashCode(@NonNull Object wrappedKey) {
        return this.getKeyHashCode(this.unwrapKey(wrappedKey));
    }

    @NonNull
    protected Object wrapKey(@NonNull K key) {
        return key;
    }

    protected K unwrapKey(@NonNull Object wrappedKey) {
        return (K)wrappedKey;
    }

    public V remove(@NonNull Object key) {
        Object[] keysValues = this.keysValues;
        int index = this.findExactIndex(keysValues, key);
        if (index == -1) {
            return null;
        }
        int valueIndex = AbstractPackedMap.getValueIndex(keysValues, index);
        Object result = keysValues[valueIndex];
        int arrayLength = keysValues.length;
        Object[] newArray = new Object[arrayLength - 2];
        System.arraycopy(keysValues, 0, newArray, 0, index);
        System.arraycopy(keysValues, index + 1, newArray, index, valueIndex - index - 1);
        System.arraycopy(keysValues, valueIndex + 1, newArray, valueIndex - 1, arrayLength - valueIndex - 1);
        this.keysValues = newArray;
        return (V)result;
    }

    public int size() {
        return this.keysValues.length / 2;
    }

    @NonNull
    public Collection<V> values() {
        return new PackedMapValues(this);
    }

    private static <V> V getValue(Object[] keysValues, int i) {
        Object value = keysValues[AbstractPackedMap.getValueIndex(keysValues, i)];
        return (V)value;
    }

    private static int getValueIndex(Object[] keysValues, int i) {
        return keysValues.length / 2 + i;
    }

    private int findExactIndex(Object[] keysValues, Object key) {
        int hashCode = this.getKeyHashCode(key);
        int keysLength = keysValues.length / 2;
        if (keysLength == 0) {
            return -1;
        }
        int minIndex = 0;
        int maxIndex = keysLength - 1;
        while (minIndex <= maxIndex) {
            int currentIndex = (maxIndex - minIndex) / 2 + minIndex;
            int candidateHashCode = this.getWrappedKeyHashCode(keysValues[currentIndex]);
            if (candidateHashCode == hashCode) {
                return this.linearSearchSameHashCode(keysValues, key, hashCode, currentIndex);
            }
            if (hashCode > candidateHashCode) {
                minIndex = currentIndex + 1;
                continue;
            }
            maxIndex = currentIndex - 1;
        }
        return -1;
    }

    private int linearSearchSameHashCode(Object[] keysValues, Object key, int hashCode, int fromIndex) {
        int keysLength = keysValues.length / 2;
        int index = fromIndex;
        Object candidateKey = keysValues[index];
        do {
            if (!this.isSame(key, this.unwrapKey(candidateKey))) continue;
            return index;
        } while (index != 0 && this.getWrappedKeyHashCode(candidateKey = keysValues[--index]) == hashCode);
        index = fromIndex + 1;
        while (index < keysLength) {
            candidateKey = keysValues[index];
            if (this.getWrappedKeyHashCode(candidateKey) != hashCode) break;
            if (this.isSame(key, this.unwrapKey(candidateKey))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected abstract boolean isSame(@NonNull Object var1, Object var2);

    class PackedMapKeySet
    implements Set<K> {
        final AbstractPackedMap<K, V> map;

        public PackedMapKeySet(AbstractPackedMap<K, V> map) {
            this.map = map;
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractPackedMap.this.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object object : c) {
                if (this.map.containsKey(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof PackedMapKeySet)) {
                return false;
            }
            return this.map.equals(((PackedMapKeySet)obj).map);
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] keysValues = AbstractPackedMap.this.keysValues;
            int keysLength = keysValues.length / 2;
            int i = -1;
            while (++i < keysLength) {
                hashCode += AbstractPackedMap.this.getWrappedKeyHashCode(keysValues[i]);
            }
            return hashCode;
        }

        @Override
        public boolean isEmpty() {
            return AbstractPackedMap.this.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                int cursor = 0;
                Object[] keysValues;
                {
                    this.keysValues = PackedMapKeySet.this.map.keysValues;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != this.keysValues.length / 2;
                }

                @Override
                public K next() {
                    int i = this.cursor;
                    int keysValuesLength = this.keysValues.length / 2;
                    if (i < keysValuesLength) {
                        Object next = AbstractPackedMap.this.unwrapKey(this.keysValues[i]);
                        this.cursor = i + 1;
                        return next;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return AbstractPackedMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] keysValues = this.map.keysValues;
            int size = keysValues.length / 2;
            return ArrayTools.copy(keysValues, size - 1);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] keysValues = this.map.keysValues;
            int size = keysValues.length / 2;
            T[] result = a.length <= size ? a : ArrayTools.createNewArray(a, size);
            System.arraycopy(keysValues, 0, result, 0, size);
            return result;
        }
    }

    class PackedMapValues
    implements Collection<V> {
        final AbstractPackedMap<K, V> map;

        public PackedMapValues(AbstractPackedMap<K, V> map) {
            this.map = map;
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractPackedMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object object : c) {
                if (this.map.containsValue(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof PackedMapValues)) {
                return false;
            }
            return this.map.equals(((PackedMapValues)obj).map);
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] keysValues = AbstractPackedMap.this.keysValues;
            int keysValuesLength = keysValues.length;
            int keysLength = keysValuesLength / 2;
            int i = keysLength - 1;
            while (++i < keysValuesLength) {
                Object value = keysValues[i];
                hashCode += value == null ? 0 : value.hashCode();
            }
            return hashCode;
        }

        @Override
        public boolean isEmpty() {
            return AbstractPackedMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                int cursor;
                Object[] keysValues;
                {
                    this.cursor = PackedMapValues.this.map.keysValues.length / 2;
                    this.keysValues = PackedMapValues.this.map.keysValues;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != this.keysValues.length;
                }

                @Override
                public V next() {
                    int i = this.cursor;
                    int keysValuesLength = this.keysValues.length;
                    if (i < keysValuesLength) {
                        Object next = this.keysValues[i];
                        this.cursor = i + 1;
                        return next;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return AbstractPackedMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] keysValues = this.map.keysValues;
            int size = keysValues.length / 2;
            Object[] result = new Object[size];
            System.arraycopy(keysValues, size, result, 0, size);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] keysValues = this.map.keysValues;
            int size = keysValues.length / 2;
            T[] result = a.length <= size ? a : ArrayTools.createNewArray(a, size);
            System.arraycopy(keysValues, size, result, 0, size);
            return result;
        }
    }
}

