/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URL;
import java.net.UnknownContentHandler;
import java.net.UnknownServiceException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import sun.net.www.MessageHeader;

public abstract class URLConnection {
    protected URL url;
    protected boolean doInput = true;
    protected boolean doOutput = false;
    private static boolean defaultAllowUserInteraction = false;
    protected boolean allowUserInteraction = defaultAllowUserInteraction;
    private static boolean defaultUseCaches = true;
    protected boolean useCaches = defaultUseCaches;
    protected boolean connected = false;
    private int connectTimeout;
    private int readTimeout;
    @Nullable
    private MessageHeader requests;
    @Nullable
    static ContentHandlerFactory factory;
    private static Hashtable<String, ContentHandler> handlers;
    private static final String contentClassPrefix = "sun.net.www.content";
    private static final String contentPathProp = "java.content.handler.pkgs";

    static {
        handlers = new Hashtable();
    }

    public abstract void connect() throws IOException;

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can not be negative");
        }
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    protected URLConnection(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public int getContentLength() {
        long l = this.getContentLengthLong();
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public long getContentLengthLong() {
        return this.getHeaderFieldLong("content-length", -1L);
    }

    @Nullable
    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    @Nullable
    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    @Nullable
    public String getHeaderField(String name) {
        return null;
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.emptyMap();
    }

    private Map<String, List<String>> emptyMap() {
        return new HashMap<String, List<String>>();
    }

    public int getHeaderFieldInt(String name, int Default) {
        String value = this.getHeaderField(name);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return Default;
        }
    }

    public long getHeaderFieldLong(String name, long Default) {
        String value = this.getHeaderField(name);
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            return Default;
        }
    }

    @Nullable
    public String getHeaderFieldKey(int n) {
        return null;
    }

    @Nullable
    public String getHeaderField(int n) {
        return null;
    }

    public Object getContent() throws IOException {
        this.getInputStream();
        return this.getContentHandler().getContent(this);
    }

    @Nullable
    public Object getContent(Class[] classes) throws IOException {
        this.getInputStream();
        return this.getContentHandler().getContent(this, classes);
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException("protocol doesn't support input");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("protocol doesn't support output");
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.url;
    }

    public void setDoInput(boolean doinput) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doInput = doinput;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public void setDoOutput(boolean dooutput) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doOutput = dooutput;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public void setAllowUserInteraction(boolean allowuserinteraction) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.allowUserInteraction = allowuserinteraction;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public static void setDefaultAllowUserInteraction(boolean defaultallowuserinteraction) {
        defaultAllowUserInteraction = defaultallowuserinteraction;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public void setUseCaches(boolean usecaches) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.useCaches = usecaches;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public void setDefaultUseCaches(boolean defaultusecaches) {
        defaultUseCaches = defaultusecaches;
    }

    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (this.requests == null) {
            this.requests = new MessageHeader();
        }
        MessageHeader requests = this.requests;
        assert (requests != null);
        requests.set(key, value);
    }

    public void addRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (this.requests == null) {
            this.requests = new MessageHeader();
        }
        MessageHeader requests = this.requests;
        assert (requests != null);
        requests.add(key, value);
    }

    @Nullable
    public String getRequestProperty(String key) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.requests == null) {
            return null;
        }
        MessageHeader requests = this.requests;
        assert (requests != null);
        return requests.findValue(key);
    }

    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.requests == null) {
            return this.emptyMap();
        }
        MessageHeader requests = this.requests;
        assert (requests != null);
        return requests.getHeaders(null);
    }

    @Deprecated
    public static void setDefaultRequestProperty(String key, String value) {
    }

    @Deprecated
    @Nullable
    public static String getDefaultRequestProperty(String key) {
        return null;
    }

    public static synchronized void setContentHandlerFactory(ContentHandlerFactory fac) {
        if (factory != null) {
            throw new Error("factory already defined");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("setFactory"));
        }
        factory = fac;
    }

    synchronized ContentHandler getContentHandler() throws UnknownServiceException {
        String contentType = this.stripOffParameters(this.getContentType());
        ContentHandler handler = null;
        if (contentType == null) {
            throw new UnknownServiceException("no content-type");
        }
        try {
            handler = handlers.get(contentType);
            if (handler != null) {
                return handler;
            }
        }
        catch (Exception exception) {}
        ContentHandlerFactory factoryLocal = factory;
        if (factoryLocal != null) {
            handler = factoryLocal.createContentHandler(contentType);
        }
        if (handler == null) {
            try {
                handler = this.lookupContentHandlerClassFor(contentType);
            }
            catch (Exception e) {
                e.printStackTrace();
                handler = UnknownContentHandler.INSTANCE;
            }
            handlers.put(contentType, handler);
        }
        return handler;
    }

    @Nullable
    private String stripOffParameters(@Nullable String contentType) {
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(59);
        if (index > 0) {
            return contentType.substring(0, index);
        }
        return contentType;
    }

    private ContentHandler lookupContentHandlerClassFor(String contentType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String contentHandlerClassName = this.typeToPackageName(contentType);
        String contentHandlerPkgPrefixes = this.getContentHandlerPkgPrefixes();
        StringTokenizer packagePrefixIter = new StringTokenizer(contentHandlerPkgPrefixes, "|");
        while (packagePrefixIter.hasMoreTokens()) {
            String packagePrefix = packagePrefixIter.nextToken().trim();
            try {
                String clsName = String.valueOf(packagePrefix) + "." + contentHandlerClassName;
                Class<?> cls = null;
                try {
                    cls = Class.forName(clsName);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if (cls == null) continue;
                ContentHandler handler = (ContentHandler)cls.newInstance();
                return handler;
            }
            catch (Exception exception) {}
        }
        return UnknownContentHandler.INSTANCE;
    }

    private String typeToPackageName(String contentType) {
        contentType = contentType.toLowerCase();
        int len = contentType.length();
        char[] nm = new char[len];
        contentType.getChars(0, len, nm, 0);
        int i = 0;
        while (i < len) {
            char c = nm[i];
            if (c == '/') {
                nm[i] = 46;
            } else if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9')) {
                nm[i] = 95;
            }
            ++i;
        }
        return new String(nm);
    }

    private String getContentHandlerPkgPrefixes() {
        String packagePrefixList = System.getProperty(contentPathProp, "");
        if (packagePrefixList != "") {
            packagePrefixList = String.valueOf(packagePrefixList) + "|";
        }
        return String.valueOf(packagePrefixList) + contentClassPrefix;
    }
}

