/*
 * Decompiled with CFR 0.152.
 */
package ej.motion;

import ej.bon.Util;
import ej.motion.Motion;

public abstract class AbstractMotion
implements Motion {
    protected final int start;
    protected final int stop;
    protected final long duration;
    protected long startTime;
    protected boolean finished;

    public AbstractMotion(int start, int stop, long duration) {
        this.start = start;
        this.stop = stop;
        this.duration = duration;
        this.start();
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void start() {
        this.finished = false;
        this.startTime = Util.platformTimeMillis();
    }

    @Override
    public boolean isFinished() {
        long time = Util.platformTimeMillis();
        return this.finished || time >= this.startTime + this.duration;
    }

    @Override
    public int getStartValue() {
        return this.start;
    }

    @Override
    public int getStopValue() {
        return this.stop;
    }

    @Override
    public int getCurrentValue() {
        if (!this.isFinished()) {
            long time = Util.platformTimeMillis();
            long elapsed = time - this.startTime;
            int value = this.computeCurrentValue(elapsed);
            if (!this.isFinished(value)) {
                return value;
            }
            this.finished = true;
        }
        return this.stop;
    }

    @Override
    public int getValue(long elapsed) {
        if (elapsed <= 0L) {
            return this.start;
        }
        if (elapsed >= this.duration) {
            return this.stop;
        }
        return this.computeCurrentValue(elapsed);
    }

    protected boolean isFinished(int value) {
        return this.stop - this.start > 0 ? value >= this.stop : value <= this.stop;
    }

    protected abstract int computeCurrentValue(long var1);
}

