/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.tools;

import ej.annotation.Nullable;

public class BasicQueue<T> {
    private Object[] array = new Object[0];
    private int headIndex = -1;
    private int tailIndex = -1;

    public void resize(int size) {
        this.array = new Object[size];
        this.headIndex = -1;
        this.tailIndex = 0;
    }

    public boolean push(Object element) {
        if (this.tailIndex == this.headIndex) {
            return false;
        }
        if (this.headIndex == -1) {
            this.headIndex = this.tailIndex;
        }
        this.array[this.tailIndex] = element;
        this.tailIndex = this.incrementIndex(this.tailIndex);
        return true;
    }

    @Nullable
    public T pop() {
        if (this.headIndex == -1) {
            return null;
        }
        Object element = this.array[this.headIndex];
        this.array[this.headIndex] = null;
        this.headIndex = this.incrementIndex(this.headIndex);
        if (this.headIndex == this.tailIndex) {
            this.headIndex = -1;
        }
        return (T)element;
    }

    public void clear() {
        if (this.headIndex != -1) {
            this.headIndex = -1;
            this.tailIndex = 0;
            int i = 0;
            while (i < this.array.length) {
                this.array[i] = null;
                ++i;
            }
        }
    }

    private int incrementIndex(int index) {
        if (index + 1 < this.array.length) {
            return index + 1;
        }
        return 0;
    }
}

