/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.encoding;

import ej.annotation.Nullable;
import ej.basictool.map.PackedMap;
import ej.hoka.http.encoding.ChunkedTransferCodingHandler;
import ej.hoka.http.encoding.ContentEncoding;
import ej.hoka.http.encoding.IdentityContentEncoding;
import ej.hoka.http.encoding.IdentityTransferEncoding;
import ej.hoka.http.encoding.TransferEncoding;
import ej.hoka.http.support.AcceptEncoding;
import ej.hoka.http.support.QualityArgument;

public class EncodingRegistry {
    private final PackedMap<String, ContentEncoding> encodingHandlers = new PackedMap();
    private final PackedMap<String, TransferEncoding> transferCodingHandlers = new PackedMap();

    public EncodingRegistry() {
        ChunkedTransferCodingHandler chunkedTransferCodingHandler = ChunkedTransferCodingHandler.getInstance();
        this.transferCodingHandlers.put((Object)chunkedTransferCodingHandler.getId().toLowerCase(), (Object)chunkedTransferCodingHandler);
    }

    public TransferEncoding getIdentityTransferCodingHandler() {
        return IdentityTransferEncoding.getInstance();
    }

    public TransferEncoding getChunkedTransferEncoding() {
        return ChunkedTransferCodingHandler.getInstance();
    }

    @Nullable
    public ContentEncoding getContentEncoding(@Nullable String encoding) {
        if (encoding == null || encoding.isEmpty() || "*".equals(encoding)) {
            return IdentityContentEncoding.getInstance();
        }
        return (ContentEncoding)this.encodingHandlers.get((Object)encoding.toLowerCase());
    }

    @Nullable
    public TransferEncoding getTransferEncoding(@Nullable String encoding) {
        if (encoding == null || encoding.isEmpty()) {
            return IdentityTransferEncoding.getInstance();
        }
        return (TransferEncoding)this.transferCodingHandlers.get((Object)encoding.toLowerCase());
    }

    public void registerContentEncoding(ContentEncoding handler) {
        if (handler == null || handler.getId() == null || handler.getId().isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.encodingHandlers.put((Object)handler.getId().toLowerCase(), (Object)handler);
    }

    public void registerTransferEncoding(TransferEncoding handler) {
        String handlerId = null;
        if (handler != null) {
            handlerId = handler.getId();
        }
        if (handler == null || handlerId == null || handlerId.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.transferCodingHandlers.put((Object)handlerId.toLowerCase(), (Object)handler);
    }

    @Nullable
    public ContentEncoding getAcceptEncodingHandler(@Nullable String encoding) {
        if (encoding == null || encoding.isEmpty()) {
            return null;
        }
        AcceptEncoding acceptEncoding = new AcceptEncoding();
        acceptEncoding.parse(encoding);
        QualityArgument[] encodings = acceptEncoding.getEncodings();
        if (encodings == null) {
            return null;
        }
        int nbEncodings = encodings.length;
        boolean[] processed = new boolean[nbEncodings];
        int pass = nbEncodings - 1;
        while (pass >= 0) {
            float localMax = 0.0f;
            int ptrMax = -1;
            int i = nbEncodings - 1;
            while (i >= 0) {
                QualityArgument arg;
                float qvalue;
                if (!processed[i] && (qvalue = (arg = encodings[i]).getQuality()) > localMax) {
                    localMax = qvalue;
                    ptrMax = i;
                }
                --i;
            }
            processed[ptrMax] = true;
            ContentEncoding handler = this.getContentEncoding(encodings[ptrMax].getArgument());
            if (handler != null) {
                return handler;
            }
            --pass;
        }
        return null;
    }
}

