/*
 * Decompiled with CFR 0.152.
 */
package ej.basictool;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class StreamUtils {
    private StreamUtils() {
    }

    public static void readFully(InputStream inputStream, byte[] array, int offset, int size) throws IOException {
        int end = offset + size;
        while (offset < end) {
            int bytesRead = inputStream.read(array, offset, end - offset);
            if (bytesRead == -1) {
                throw new EOFException();
            }
            offset += bytesRead;
        }
    }

    public static void skipFully(InputStream inputStream, long size) throws IOException {
        while (size > 0L) {
            long bytesSkipped = inputStream.skip(size);
            if (bytesSkipped == 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException();
                }
                --size;
                continue;
            }
            size -= bytesSkipped;
        }
    }
}

