/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import ej.annotation.Nullable;
import java.time.BigInteger;
import java.time.IntegerHelper;
import java.util.Arrays;

class MutableBigInteger {
    int[] value;
    int intLen;
    int offset = 0;

    MutableBigInteger() {
        this.value = new int[1];
        this.intLen = 0;
    }

    MutableBigInteger(int val) {
        this.value = new int[1];
        this.intLen = 1;
        this.value[0] = val;
    }

    MutableBigInteger(int[] val) {
        this.value = val;
        this.intLen = val.length;
    }

    MutableBigInteger(MutableBigInteger val) {
        this.intLen = val.intLen;
        this.value = Arrays.copyOfRange(val.value, val.offset, val.offset + this.intLen);
    }

    private int[] getMagnitudeArray() {
        if (this.offset > 0 || this.value.length != this.intLen) {
            return Arrays.copyOfRange(this.value, this.offset, this.offset + this.intLen);
        }
        return this.value;
    }

    BigInteger toBigInteger(int sign) {
        if (this.intLen == 0 || sign == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(this.getMagnitudeArray(), sign);
    }

    void clear() {
        this.intLen = 0;
        this.offset = 0;
        int index = 0;
        int n = this.value.length;
        while (index < n) {
            this.value[index] = 0;
            ++index;
        }
    }

    void reset() {
        this.intLen = 0;
        this.offset = 0;
    }

    final int compare(MutableBigInteger b) {
        int blen = b.intLen;
        if (this.intLen < blen) {
            return -1;
        }
        if (this.intLen > blen) {
            return 1;
        }
        int[] bval = b.value;
        int i = this.offset;
        int j = b.offset;
        while (i < this.intLen + this.offset) {
            int b1 = this.value[i] + Integer.MIN_VALUE;
            int b2 = bval[j] + Integer.MIN_VALUE;
            if (b1 < b2) {
                return -1;
            }
            if (b1 > b2) {
                return 1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    final void normalize() {
        if (this.intLen == 0) {
            this.offset = 0;
            return;
        }
        int index = this.offset;
        if (this.value[index] != 0) {
            return;
        }
        int indexBound = index + this.intLen;
        while (++index < indexBound && this.value[index] == 0) {
        }
        int numZeros = index - this.offset;
        this.intLen -= numZeros;
        this.offset = this.intLen == 0 ? 0 : this.offset + numZeros;
    }

    void setValue(int[] val, int length) {
        this.value = val;
        this.intLen = length;
        this.offset = 0;
    }

    void rightShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        this.intLen -= nInts;
        if (nBits == 0) {
            return;
        }
        int bitsInHighWord = BigInteger.bitLengthForInt(this.value[this.offset]);
        if (nBits >= bitsInHighWord) {
            this.primitiveLeftShift(32 - nBits);
            --this.intLen;
        } else {
            this.primitiveRightShift(nBits);
        }
    }

    void leftShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int bitsInHighWord = BigInteger.bitLengthForInt(this.value[this.offset]);
        if (n <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
            return;
        }
        int newLen = this.intLen + nInts + 1;
        if (nBits <= 32 - bitsInHighWord) {
            --newLen;
        }
        if (this.value.length < newLen) {
            int[] result = new int[newLen];
            int i = 0;
            while (i < this.intLen) {
                result[i] = this.value[this.offset + i];
                ++i;
            }
            this.setValue(result, newLen);
        } else if (this.value.length - this.offset >= newLen) {
            int i = 0;
            while (i < newLen - this.intLen) {
                this.value[this.offset + this.intLen + i] = 0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.intLen) {
                this.value[i] = this.value[this.offset + i];
                ++i;
            }
            i = this.intLen;
            while (i < newLen) {
                this.value[i] = 0;
                ++i;
            }
            this.offset = 0;
        }
        this.intLen = newLen;
        if (nBits == 0) {
            return;
        }
        if (nBits <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
        } else {
            this.primitiveRightShift(32 - nBits);
        }
    }

    private int divadd(int[] a, int[] result, int offset) {
        long carry = 0L;
        int j = a.length - 1;
        while (j >= 0) {
            long sum = ((long)a[j] & 0xFFFFFFFFL) + ((long)result[j + offset] & 0xFFFFFFFFL) + carry;
            result[j + offset] = (int)sum;
            carry = sum >>> 32;
            --j;
        }
        return (int)carry;
    }

    private int mulsub(int[] q, int[] a, int x, int len, int offset) {
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset += len;
        int j = len - 1;
        while (j >= 0) {
            long product = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry;
            long difference = (long)q[offset] - product;
            q[offset--] = (int)difference;
            carry = (product >>> 32) + (long)((difference & 0xFFFFFFFFL) > ((long)(~((int)product)) & 0xFFFFFFFFL) ? 1 : 0);
            --j;
        }
        return (int)carry;
    }

    private int mulsubBorrow(int[] q, int[] a, int x, int len, int offset) {
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset += len;
        int j = len - 1;
        while (j >= 0) {
            long difference;
            long product;
            carry = (product >>> 32) + (long)(((difference = (long)q[offset--] - (product = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry)) & 0xFFFFFFFFL) > ((long)(~((int)product)) & 0xFFFFFFFFL) ? 1 : 0);
            --j;
        }
        return (int)carry;
    }

    private final void primitiveRightShift(int n) {
        int[] val = this.value;
        int n2 = 32 - n;
        int i = this.offset + this.intLen - 1;
        int c = val[i];
        while (i > this.offset) {
            int b = c;
            c = val[i - 1];
            val[i] = c << n2 | b >>> n;
            --i;
        }
        int n3 = this.offset;
        val[n3] = val[n3] >>> n;
    }

    private final void primitiveLeftShift(int n) {
        int[] val = this.value;
        int n2 = 32 - n;
        int i = this.offset;
        int c = val[i];
        int m = i + this.intLen - 1;
        while (i < m) {
            int b = c;
            c = val[i + 1];
            val[i] = b << n | c >>> n2;
            ++i;
        }
        int n3 = this.offset + this.intLen - 1;
        val[n3] = val[n3] << n;
    }

    int subtract(MutableBigInteger b) {
        int resultLen;
        MutableBigInteger a = this;
        int[] result = this.value;
        int sign = a.compare(b);
        if (sign == 0) {
            this.reset();
            return 0;
        }
        if (sign < 0) {
            MutableBigInteger tmp = a;
            a = b;
            b = tmp;
        }
        if (result.length < (resultLen = a.intLen)) {
            result = new int[resultLen];
        }
        long diff = 0L;
        int x = a.intLen;
        int y = b.intLen;
        int rstart = result.length - 1;
        while (y > 0) {
            diff = ((long)a.value[--x + a.offset] & 0xFFFFFFFFL) - ((long)b.value[--y + b.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            result[rstart--] = (int)diff;
        }
        while (x > 0) {
            diff = ((long)a.value[--x + a.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            result[rstart--] = (int)diff;
        }
        this.value = result;
        this.intLen = resultLen;
        this.offset = this.value.length - resultLen;
        this.normalize();
        return sign;
    }

    int divideOneWord(int divisor, MutableBigInteger quotient) {
        long divisorLong = (long)divisor & 0xFFFFFFFFL;
        if (this.intLen == 1) {
            long dividendValue = (long)this.value[this.offset] & 0xFFFFFFFFL;
            int q = (int)(dividendValue / divisorLong);
            int r = (int)(dividendValue - (long)q * divisorLong);
            quotient.value[0] = q;
            quotient.intLen = q == 0 ? 0 : 1;
            quotient.offset = 0;
            return r;
        }
        if (quotient.value.length < this.intLen) {
            quotient.value = new int[this.intLen];
        }
        quotient.offset = 0;
        quotient.intLen = this.intLen;
        int shift = IntegerHelper.numberOfLeadingZeros(divisor);
        int rem = this.value[this.offset];
        long remLong = (long)rem & 0xFFFFFFFFL;
        if (remLong < divisorLong) {
            quotient.value[0] = 0;
        } else {
            quotient.value[0] = (int)(remLong / divisorLong);
            rem = (int)(remLong - (long)quotient.value[0] * divisorLong);
            remLong = (long)rem & 0xFFFFFFFFL;
        }
        int xlen = this.intLen;
        while (--xlen > 0) {
            int q;
            long dividendEstimate = remLong << 32 | (long)this.value[this.offset + this.intLen - xlen] & 0xFFFFFFFFL;
            if (dividendEstimate >= 0L) {
                q = (int)(dividendEstimate / divisorLong);
                rem = (int)(dividendEstimate - (long)q * divisorLong);
            } else {
                long tmp = MutableBigInteger.divWord(dividendEstimate, divisor);
                q = (int)(tmp & 0xFFFFFFFFL);
                rem = (int)(tmp >>> 32);
            }
            quotient.value[this.intLen - xlen] = q;
            remLong = (long)rem & 0xFFFFFFFFL;
        }
        quotient.normalize();
        if (shift > 0) {
            return rem % divisor;
        }
        return rem;
    }

    MutableBigInteger divideKnuth(MutableBigInteger b, MutableBigInteger quotient) {
        MutableBigInteger remainder = this.divideKnuth(b, quotient, true);
        assert (remainder != null);
        return remainder;
    }

    @Nullable
    MutableBigInteger divideKnuth(MutableBigInteger b, MutableBigInteger quotient, boolean needRemainder) {
        if (b.intLen == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.intLen == 0) {
            quotient.offset = 0;
            quotient.intLen = 0;
            return needRemainder ? new MutableBigInteger() : null;
        }
        int cmp = this.compare(b);
        if (cmp < 0) {
            quotient.offset = 0;
            quotient.intLen = 0;
            return needRemainder ? new MutableBigInteger(this) : null;
        }
        if (cmp == 0) {
            quotient.intLen = 1;
            quotient.value[0] = 1;
            quotient.offset = 0;
            return needRemainder ? new MutableBigInteger() : null;
        }
        quotient.clear();
        if (b.intLen == 1) {
            int r = this.divideOneWord(b.value[b.offset], quotient);
            if (needRemainder) {
                if (r == 0) {
                    return new MutableBigInteger();
                }
                return new MutableBigInteger(r);
            }
            return null;
        }
        return this.divideMagnitude(b, quotient, needRemainder);
    }

    private static void copyAndShift(int[] src, int srcFrom, int srcLen, int[] dst, int dstFrom, int shift) {
        int n2 = 32 - shift;
        int c = src[srcFrom];
        int i = 0;
        while (i < srcLen - 1) {
            int b = c;
            c = src[++srcFrom];
            dst[dstFrom + i] = b << shift | c >>> n2;
            ++i;
        }
        dst[dstFrom + srcLen - 1] = c << shift;
    }

    @Nullable
    private MutableBigInteger divideMagnitude(MutableBigInteger div, MutableBigInteger quotient, boolean needRemainder) {
        MutableBigInteger rem;
        int[] divisor;
        int shift = IntegerHelper.numberOfLeadingZeros(div.value[div.offset]);
        int dlen = div.intLen;
        if (shift > 0) {
            int[] remarr;
            divisor = new int[dlen];
            MutableBigInteger.copyAndShift(div.value, div.offset, dlen, divisor, 0, shift);
            if (IntegerHelper.numberOfLeadingZeros(this.value[this.offset]) >= shift) {
                remarr = new int[this.intLen + 1];
                rem = new MutableBigInteger(remarr);
                rem.intLen = this.intLen;
                rem.offset = 1;
                MutableBigInteger.copyAndShift(this.value, this.offset, this.intLen, remarr, 1, shift);
            } else {
                remarr = new int[this.intLen + 2];
                rem = new MutableBigInteger(remarr);
                rem.intLen = this.intLen + 1;
                rem.offset = 1;
                int rFrom = this.offset;
                int c = 0;
                int n2 = 32 - shift;
                int i = 1;
                while (i < this.intLen + 1) {
                    int b = c;
                    c = this.value[rFrom];
                    remarr[i] = b << shift | c >>> n2;
                    ++i;
                    ++rFrom;
                }
                remarr[this.intLen + 1] = c << shift;
            }
        } else {
            divisor = Arrays.copyOfRange(div.value, div.offset, div.offset + div.intLen);
            rem = new MutableBigInteger(new int[this.intLen + 1]);
            System.arraycopy(this.value, this.offset, rem.value, 1, this.intLen);
            rem.intLen = this.intLen;
            rem.offset = 1;
        }
        int nlen = rem.intLen;
        int limit = nlen - dlen + 1;
        if (quotient.value.length < limit) {
            quotient.value = new int[limit];
            quotient.offset = 0;
        }
        quotient.intLen = limit;
        int[] q = quotient.value;
        if (rem.intLen == nlen) {
            rem.offset = 0;
            rem.value[0] = 0;
            ++rem.intLen;
        }
        int dh = divisor[0];
        long dhLong = (long)dh & 0xFFFFFFFFL;
        int dl = divisor[1];
        int j = 0;
        while (j < limit - 1) {
            int qhat = 0;
            int qrem = 0;
            boolean skipCorrection = false;
            int nh = rem.value[j + rem.offset];
            int nh2 = nh + Integer.MIN_VALUE;
            int nm = rem.value[j + 1 + rem.offset];
            if (nh == dh) {
                qhat = -1;
                qrem = nh + nm;
                skipCorrection = qrem + Integer.MIN_VALUE < nh2;
            } else {
                long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
                if (nChunk >= 0L) {
                    qhat = (int)(nChunk / dhLong);
                    qrem = (int)(nChunk - (long)qhat * dhLong);
                } else {
                    long tmp = MutableBigInteger.divWord(nChunk, dh);
                    qhat = (int)(tmp & 0xFFFFFFFFL);
                    qrem = (int)(tmp >>> 32);
                }
            }
            if (qhat != 0) {
                long nl;
                long rs;
                long estProduct;
                if (!skipCorrection && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[j + 2 + rem.offset] & 0xFFFFFFFFL))) {
                    --qhat;
                    if (((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && this.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                        --qhat;
                    }
                }
                rem.value[j + rem.offset] = 0;
                int borrow = this.mulsub(rem.value, divisor, qhat, dlen, j + rem.offset);
                if (borrow + Integer.MIN_VALUE > nh2) {
                    this.divadd(divisor, rem.value, j + 1 + rem.offset);
                }
                q[j] = --qhat;
            }
            ++j;
        }
        int qhat = 0;
        int qrem = 0;
        boolean skipCorrection = false;
        int nh = rem.value[limit - 1 + rem.offset];
        int nh2 = nh + Integer.MIN_VALUE;
        int nm = rem.value[limit + rem.offset];
        if (nh == dh) {
            qhat = -1;
            qrem = nh + nm;
            skipCorrection = qrem + Integer.MIN_VALUE < nh2;
        } else {
            long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
            if (nChunk >= 0L) {
                qhat = (int)(nChunk / dhLong);
                qrem = (int)(nChunk - (long)qhat * dhLong);
            } else {
                long tmp = MutableBigInteger.divWord(nChunk, dh);
                qhat = (int)(tmp & 0xFFFFFFFFL);
                qrem = (int)(tmp >>> 32);
            }
        }
        if (qhat != 0) {
            long nl;
            long rs;
            long estProduct;
            if (!skipCorrection && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[limit + 1 + rem.offset] & 0xFFFFFFFFL))) {
                --qhat;
                if (((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && this.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                    --qhat;
                }
            }
            rem.value[limit - 1 + rem.offset] = 0;
            int borrow = needRemainder ? this.mulsub(rem.value, divisor, qhat, dlen, limit - 1 + rem.offset) : this.mulsubBorrow(rem.value, divisor, qhat, dlen, limit - 1 + rem.offset);
            if (borrow + Integer.MIN_VALUE > nh2 && needRemainder) {
                this.divadd(divisor, rem.value, limit - 1 + 1 + rem.offset);
            }
            q[limit - 1] = --qhat;
        }
        if (needRemainder) {
            if (shift > 0) {
                rem.rightShift(shift);
            }
            rem.normalize();
        }
        quotient.normalize();
        return needRemainder ? rem : null;
    }

    private boolean unsignedLongCompare(long one, long two) {
        return one + Long.MIN_VALUE > two + Long.MIN_VALUE;
    }

    static long divWord(long n, int d) {
        long dLong = (long)d & 0xFFFFFFFFL;
        if (dLong == 1L) {
            long q = (int)n;
            long r = 0L;
            return r << 32 | q & 0xFFFFFFFFL;
        }
        long q = (n >>> 1) / (dLong >>> 1);
        long r = n - q * dLong;
        while (r < 0L) {
            r += dLong;
            --q;
        }
        while (r >= dLong) {
            r -= dLong;
            ++q;
        }
        return r << 32 | q & 0xFFFFFFFFL;
    }
}

