/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import ej.annotation.Nullable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.AbstractChronology;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;

public final class Month
extends Enum<Month>
implements TemporalAccessor,
TemporalAdjuster {
    public static final /* enum */ Month JANUARY = new Month();
    public static final /* enum */ Month FEBRUARY = new Month();
    public static final /* enum */ Month MARCH = new Month();
    public static final /* enum */ Month APRIL = new Month();
    public static final /* enum */ Month MAY = new Month();
    public static final /* enum */ Month JUNE = new Month();
    public static final /* enum */ Month JULY = new Month();
    public static final /* enum */ Month AUGUST = new Month();
    public static final /* enum */ Month SEPTEMBER = new Month();
    public static final /* enum */ Month OCTOBER = new Month();
    public static final /* enum */ Month NOVEMBER = new Month();
    public static final /* enum */ Month DECEMBER = new Month();
    private static final /* synthetic */ Month[] ENUM$VALUES;

    static {
        ENUM$VALUES = new Month[]{JANUARY, FEBRUARY, MARCH, APRIL, MAY, JUNE, JULY, AUGUST, SEPTEMBER, OCTOBER, NOVEMBER, DECEMBER};
    }

    public static Month of(int month) {
        if (month < 1 || month > 12) {
            throw new DateTimeException("Invalid value for MonthOfYear: " + month);
        }
        Month monthEnum = Month.values()[month - 1];
        assert (monthEnum != null);
        return monthEnum;
    }

    public static Month from(TemporalAccessor temporal) {
        if (temporal instanceof Month) {
            return (Month)temporal;
        }
        try {
            if (!IsoChronology.INSTANCE.equals(AbstractChronology.from(temporal))) {
                temporal = LocalDate.from(temporal);
            }
            return Month.of(temporal.get(ChronoField.MONTH_OF_YEAR));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain Month from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    @Override
    public boolean isSupported(@Nullable TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.MONTH_OF_YEAR;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return field.range();
        }
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                return field.range();
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return this.getValue();
        }
        ValueRange range = this.range(field);
        if (!range.isIntValue()) {
            throw new UnsupportedTemporalTypeException("Invalid field " + field + " for get() method, use getLong() instead");
        }
        long value = this.getLong(field);
        if (!range.isValidValue(value)) {
            throw new DateTimeException("Invalid value for " + field + " (valid values " + range + "): " + value);
        }
        return (int)value;
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    public Month plus(long months) {
        int amount = (int)(months % 12L);
        Month month = Month.values()[(this.ordinal() + (amount + 12)) % 12];
        assert (month != null);
        return month;
    }

    public Month minus(long months) {
        return this.plus(-(months % 12L));
    }

    public int length(boolean leapYear) {
        switch (this) {
            case FEBRUARY: {
                return leapYear ? 29 : 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int minLength() {
        switch (this) {
            case FEBRUARY: {
                return 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int maxLength() {
        switch (this) {
            case FEBRUARY: {
                return 29;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int firstDayOfYear(boolean leapYear) {
        int leap = leapYear ? 1 : 0;
        switch (this) {
            case JANUARY: {
                return 1;
            }
            case FEBRUARY: {
                return 32;
            }
            case MARCH: {
                return 60 + leap;
            }
            case APRIL: {
                return 91 + leap;
            }
            case MAY: {
                return 121 + leap;
            }
            case JUNE: {
                return 152 + leap;
            }
            case JULY: {
                return 182 + leap;
            }
            case AUGUST: {
                return 213 + leap;
            }
            case SEPTEMBER: {
                return 244 + leap;
            }
            case OCTOBER: {
                return 274 + leap;
            }
            case NOVEMBER: {
                return 305 + leap;
            }
        }
        return 335 + leap;
    }

    public Month firstMonthOfQuarter() {
        Month month = Month.values()[this.ordinal() / 3 * 3];
        assert (month != null);
        return month;
    }

    @Override
    @Nullable
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.MONTHS;
        }
        if (query == TemporalQueries.zoneId() || query == TemporalQueries.chronology() || query == TemporalQueries.precision()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!AbstractChronology.from(temporal).equals(IsoChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.MONTH_OF_YEAR, this.getValue());
    }

    public static Month[] values() {
        Month[] monthArray = ENUM$VALUES;
        int n = monthArray.length;
        Month[] monthArray2 = new Month[n];
        System.arraycopy(ENUM$VALUES, 0, monthArray2, 0, n);
        return monthArray2;
    }

    public static Month valueOf(String string) {
        return Enum.valueOf(Month.class, string);
    }
}

