/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket;

import ej.websocket.ConnectionStates;
import ej.websocket.Messages;
import ej.websocket.OnTimeOutCloser;
import ej.websocket.ReasonForClosure;
import ej.websocket.WebSocket;
import ej.websocket.WebSocketException;
import ej.websocket.frame.FrameScanner;
import ej.websocket.frame.RawFrame;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

class Receiver
implements Runnable {
    private final WebSocket ws;
    private final FrameScanner scanner;

    Receiver(WebSocket ws) {
        this.ws = ws;
        this.scanner = new FrameScanner(ws.getInputStream());
    }

    @Override
    public void run() {
        Messages.LOGGER.log('F', Messages.CATEGORY, 4, new Object[]{this});
        try {
            RawFrame fullFrame = null;
            while (this.ws.getCurrentState() != ConnectionStates.CLOSED) {
                boolean isComplete = true;
                RawFrame f = this.scanner.getFrame();
                Messages.LOGGER.log('G', Messages.CATEGORY, 5, new Object[]{this});
                if (f.getFIN() == 0) {
                    if (fullFrame == null && f.getOpcode() != 0) {
                        fullFrame = f;
                        isComplete = false;
                    } else if (fullFrame != null && f.getOpcode() == 0) {
                        fullFrame.append(f);
                        isComplete = false;
                    }
                } else if (f.getFIN() == 1 && fullFrame != null) {
                    if (f.getOpcode() == 0) {
                        fullFrame.append(f);
                        f = fullFrame;
                        fullFrame = null;
                    } else if (f.getOpcode() != 9 && f.getOpcode() != 10 && f.getOpcode() != 8) {
                        throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -8));
                    }
                }
                if (!isComplete) continue;
                this.handleFrame(f);
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        Messages.LOGGER.log('F', Messages.CATEGORY, 6, new Object[]{this});
    }

    private void handleError(Exception e) {
        if (this.ws.getCurrentState() == ConnectionStates.OPEN) {
            Messages.LOGGER.log('S', Messages.CATEGORY, -255, (Throwable)e, new Object[]{this});
            WebSocketException wse = new WebSocketException(e);
            this.ws.getEndpoint().onError(this.ws, wse);
            this.ws.getEndpoint().onClose(this.ws, new ReasonForClosure(1006, null));
        } else {
            Messages.LOGGER.log('F', Messages.CATEGORY, 2, (Throwable)e, new Object[]{this});
        }
        this.ws.closeUnderlyingTCPConnection();
    }

    private void handleFrame(RawFrame f) throws IOException, WebSocketException {
        if (this.validate(f)) {
            try {
                this.handle(f);
            }
            catch (IllegalStateException e) {
                Messages.LOGGER.log('I', Messages.CATEGORY, 8, (Throwable)e, new Object[]{this});
            }
        } else {
            Messages.LOGGER.log('W', Messages.CATEGORY, 9, new Object[]{this});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(RawFrame f) throws IOException, IllegalStateException, WebSocketException {
        switch (f.getOpcode()) {
            case 1: {
                Messages.LOGGER.log('G', Messages.CATEGORY, 10, new Object[]{this});
                String text = new String(f.getPayload(true));
                String response = this.ws.getEndpoint().onTextMessage(this.ws, text);
                if (response == null) break;
                this.ws.sendText(response);
                break;
            }
            case 2: {
                Messages.LOGGER.log('G', Messages.CATEGORY, 11, new Object[]{this});
                byte[] binary = f.getPayload(true);
                byte[] binaryResponse = this.ws.getEndpoint().onBinaryMessage(this.ws, binary);
                if (binaryResponse == null) break;
                this.ws.sendBinary(binaryResponse);
                break;
            }
            case 8: {
                Messages.LOGGER.log('G', Messages.CATEGORY, 12, new Object[]{this});
                ReasonForClosure reasonForClosure = new ReasonForClosure(1005, null);
                if (f.getLength() != 0) {
                    byte[] payload = f.getPayload(true);
                    int msb = payload[0] & 0xFF;
                    int lsb = payload[1] & 0xFF;
                    int code = (msb << 8) + lsb;
                    String reason = new String(f.getPayload(true), 2, payload.length - 2);
                    reasonForClosure.setCode(code);
                    reasonForClosure.setReason(reason);
                }
                WebSocket webSocket = this.ws;
                synchronized (webSocket) {
                    if (this.ws.getCurrentState() == ConnectionStates.CLOSING) {
                        OnTimeOutCloser closer;
                        OnTimeOutCloser onTimeOutCloser = closer = this.ws.getOnTimeOutCloser();
                        synchronized (onTimeOutCloser) {
                            this.ws.closeUnderlyingTCPConnection();
                            closer.setClosed(true);
                        }
                    } else {
                        this.ws.respondToClosingHandshake(reasonForClosure);
                    }
                }
                this.ws.getEndpoint().onClose(this.ws, reasonForClosure);
                break;
            }
            case 9: {
                Messages.LOGGER.log('G', Messages.CATEGORY, 13, new Object[]{this});
                this.ws.pong(f.getPayload(true));
                this.ws.getEndpoint().onPing(f.getPayload(true));
                break;
            }
            case 10: {
                Messages.LOGGER.log('G', Messages.CATEGORY, 14, new Object[]{this});
                this.ws.getEndpoint().onPong(f.getPayload(true));
                break;
            }
            default: {
                Messages.LOGGER.log('S', Messages.CATEGORY, -1, new Object[]{this});
                throw new WebSocketException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -1));
            }
        }
    }

    private boolean validate(RawFrame f) throws IOException {
        try {
            if (!f.isValid()) {
                this.ws.close(new ReasonForClosure(1002, null));
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            Messages.LOGGER.log('F', Messages.CATEGORY, -2, (Throwable)e, new Object[]{this});
            this.ws.close(new ReasonForClosure(1007, e.getMessage()));
            return false;
        }
        catch (IOException e) {
            Messages.LOGGER.log('F', Messages.CATEGORY, -255, (Throwable)e, new Object[]{this});
            this.ws.close(new ReasonForClosure(1002, e.getMessage()));
            return false;
        }
        if (f.getRSV() != 0) {
            this.ws.close(new ReasonForClosure(1002, null));
            return false;
        }
        if (f.isMasked()) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -3));
        }
        return true;
    }
}

