/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket;

import ej.websocket.Endpoint;
import ej.websocket.Messages;
import ej.websocket.WebSocket;
import ej.websocket.WebSocketURI;
import java.io.IOException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public class WebSocketSecure
extends WebSocket {
    private final SSLContext context;

    public WebSocketSecure(WebSocketURI uri, Endpoint endpoint) throws IllegalArgumentException, NoSuchAlgorithmException {
        this(uri, endpoint, null);
    }

    public WebSocketSecure(WebSocketURI uri, Endpoint endpoint, SSLContext context) throws IllegalArgumentException, NoSuchAlgorithmException {
        super(uri, endpoint);
        if (context == null && uri.isSecure()) {
            context = SSLContext.getDefault();
        }
        this.context = context;
    }

    protected void setupSocket() throws IOException {
        WebSocketURI uri = this.getURI();
        if (this.context != null && uri.isSecure()) {
            Socket socket = null;
            try {
                socket = this.context.getSocketFactory().createSocket(uri.getHost(), uri.getPort());
                if (socket instanceof SSLSocket) {
                    ((SSLSocket)socket).startHandshake();
                }
            }
            catch (IOException e) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e2) {
                        Messages.LOGGER.log('I', Messages.CATEGORY, 22, (Throwable)e2, new Object[]{this});
                    }
                }
                throw new IOException(e);
            }
            this.setSocket(socket);
        } else {
            super.setupSocket();
        }
    }
}

