/*
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.widget.container;

import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.util.Size;

/**
 * Lays out any number of children by stacking them.
 * <p>
 * In an overlap container, each child will have the position and size of the available space.
 */
public class OverlapContainer extends Container {

	@Override
	public void addChild(Widget child) {
		super.addChild(child);
	}

	@Override
	public void removeChild(Widget child) {
		super.removeChild(child);
	}

	@Override
	public void insertChild(Widget child, int index) {
		super.insertChild(child, index);
	}

	@Override
	public void replaceChild(int index, Widget child) {
		super.replaceChild(index, child);
	}

	@Override
	public void removeAllChildren() {
		super.removeAllChildren();
	}

	@Override
	public void changeChildIndex(Widget child, int index) {
		super.changeChildIndex(child, index);
	}

	@Override
	protected void computeContentOptimalSize(Size size) {
		int widthHint = size.getWidth();
		int heightHint = size.getHeight();

		int width = 0;
		int height = 0;
		for (Widget child : getChildren()) {
			assert (child != null);

			// compute child optimal size
			computeChildOptimalSize(child, widthHint, heightHint);

			// update container optimal size
			width = Math.max(width, child.getWidth());
			height = Math.max(height, child.getHeight());
		}

		// set container optimal size
		size.setSize(width, height);
	}

	@Override
	protected void layOutChildren(int contentWidth, int contentHeight) {
		for (Widget child : getChildren()) {
			assert (child != null);

			// lay out child
			layOutChild(child, 0, 0, contentWidth, contentHeight);
		}
	}
}
