/*
 * Java
 *
 * Copyright 2015-2019 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.event;

import java.security.Permission;

import ej.annotation.Nullable;
import ej.microui.util.EventHandler;

/**
 * Permission to handle events generated by an {@link EventGenerator}. Permission is checked when calling
 * {@link EventGenerator#setEventHandler(EventHandler)}.
 */
public class EventPermission extends Permission {

	/**
	 * Creates a permission for events generated by the given event generator with <code>null</code> as name.
	 *
	 * @param gen
	 *            the event generator.
	 */
	public EventPermission(@Nullable EventGenerator gen) {
		super(null);
	}

	/**
	 * Gets the event generator handled by this permission.
	 *
	 * @return the event generator.
	 */
	public @Nullable EventGenerator getEventGenerator() {
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
