/*
 * Java
 *
 * Copyright 2015-2019 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * Permission to start or stop MicroUI. Permissions are checked when calling {@link MicroUI#start()} and
 * {@link MicroUI#stop()}
 *
 * @see MicroUI#start()
 * @see MicroUI#stop()
 */
public class MicroUIPermission extends Permission {

	/**
	 * Action to start MicroUI.
	 */
	public static final String ACTION_START = "start"; //$NON-NLS-1$

	/**
	 * Action to stop MicroUI.
	 */
	public static final String ACTION_STOP = "stop"; //$NON-NLS-1$

	/**
	 * Creates a permission for events generated by the given event generator with <code>null</code> as name.
	 *
	 * @param action
	 *            the action to check.
	 */
	public MicroUIPermission(String action) {
		super(null);
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
