package ej.ecom.io;

import java.io.IOException;

/**
 * This interface defines the API for {@link Connection} factories.
 * A Connection factory is a class that implements this interface with the following fully qualified name format:
 * <pre>
 * [packageName].[protocol].ConnectionFactory
 * </pre>
 * @see Connector#open(String)
 */
public interface ConnectionFactory{

	/**
	 * Open a connection with the specified URL.
	 * @param url the connection URL to open
	 * @return the open {@link Connection}.
	 * @throws ConnectionNotFoundException if connection protocol is not found
	 * @throws IOException if an I/O error occurs
	 */
	public abstract Connection open(String url, int mode, boolean timeouts) throws IOException;
}