package ej.ecom;

/**
 * The {@link RegistrationListener} interface defines methods for notification of registered and unregistered devices.
 * @see DeviceManager#addRegistrationListener(RegistrationListener, Class) method
 */
public interface RegistrationListener<D extends Device> {

	/**
	 * This method is called when a new device is registered and if it is allowed to be notified of events on the registered event class.
	 * @param event the device registration event.
	 */
	public void deviceRegistered(RegistrationEvent<D> event);
	
	/**
	 * This method is called when a new device is unregistered and if it is allowed to be notified of events on the registered event class.
	 * @param event the device unregistration event.
	 */
	public void deviceUnregistered(RegistrationEvent<D> event);
	
}
