package ej.ecom;

/**
 * Descriptive information of the hardware of a {@link Device}.
 * When all devices sharing the same descriptor are unregistered, informations may be unavailable.
 * An {@link HardwareDescriptor} is identified by a set of properties.
 */
public interface HardwareDescriptor<D extends Device> {

	/**
	 * Returns the name of this descriptor.
	 * @return the name of the descriptor, {@link Device#UNKNOWN_NAME} if its name is unavailable.
	 */
	public String getName();
	
	/**
	 * Returns the value of the given property.
	 * @param propertyName the property name
	 * @return null if the property is unknown or is unavailable.
	 */
	public String getProperty(String propertyName);
	
	/**
	 * Returns a snapshot of available properties names for this descriptor.
	 * Subsequent calls to {@link #getProperty(String)} with properties returned by this method are not ensured to return a non null value.
	 * @return an empty array if the properties are unavailable
	 */
	public String[] getPropertyNames();

	/**
	 * Returns a snapshot of available properties values for this descriptor.
	 * @return an empty array if the properties are unavailable
	 */
	public String[] getPropertyValues();
	
}
