/*
 * Copyright 2015-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet;

import ej.mwt.Widget;
import ej.mwt.style.Style;

/**
 * Represents a stylesheet.
 * <p>
 * A stylesheet associates a style to a widget.
 * <p>
 * By default, every widget has the same style:
 * <ul>
 * <li>black color,</li>
 * <li>white plain rectangular background,</li>
 * <li>no border,</li>
 * <li>no padding,</li>
 * <li>no margin,</li>
 * <li>no dimension,</li>
 * <li>default font,</li>
 * <li>left horizontal alignment,</li>
 * <li>top vertical alignment,</li>
 * <li>no extra field.</li>
 * </ul>
 */
public interface Stylesheet {

	/**
	 * Gets the style for a widget.
	 *
	 * @param widget
	 *            the widget to get the style for.
	 * @return the style applied to the widget.
	 */
	Style getStyle(Widget widget);

}
