/*
 * Copyright 2022-2023 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.android.internal;

/**
 * Handles the events related to the application display.
 */
public interface InternalDisplayListener {

	/**
	 * Handles the tearing signal of the application display.
	 */
	void onTearing();

	/**
	 * Handles a pointer press of the application display.
	 *
	 * @param x
	 *            the x coordinate of the pointer.
	 * @param y
	 *            the y coordinate of the pointer.
	 */
	void onPointerPress(int x, int y);

	/**
	 * Handles a pointer release of the application display.
	 */
	void onPointerRelease();

	/**
	 * Handles a pointer move of the application display.
	 *
	 * @param x
	 *            the x coordinate of the pointer.
	 * @param y
	 *            the y coordinate of the pointer.
	 * @since 1.1
	 */
	default void onPointerMove(int x, int y) {
		// do nothing by default
	}
}
