/*
 * Java
 *
 * Copyright 2018-2019 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.util.message;

/**
 * Levels for messages.
 */
public final class Level {

	/**
	 * Severe.
	 */
	public static final char SEVERE = 'S';

	/**
	 * Warning.
	 */
	public static final char WARNING = 'W';

	/**
	 * Info.
	 */
	public static final char INFO = 'I';

	/**
	 * Config.
	 */
	public static final char CONFIG = 'C';

	/**
	 * Fine.
	 */
	public static final char FINE = 'F';

	/**
	 * Finer.
	 */
	public static final char FINER = 'G';

	/**
	 * Finest.
	 */
	public static final char FINEST = 'H';

	private Level() {
		// Forbid instantiation.
	}

}
