/*
 * <Java>
 *
 * Copyright 2015-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.service.loader;

import ej.annotation.Nullable;

/**
 * Service loader that retrieves services implementations using system properties.
 *
 * @see System#getProperty(String)
 */
public class SystemPropertiesServiceLoader extends DependencyInjectionServiceLoader {

	@Override
	@Nullable
	protected String getImplementationName(String serviceName) {
		return System.getProperty(serviceName);
	}

}
