/*
 * <Java>
 *
 * Copyright 2015-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.service.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import ej.annotation.Nullable;

/**
 * Service loader that retrieves services implementations from a property file.
 */
public class FilePropertiesServiceLoader extends DependencyInjectionServiceLoader {

	private final String file;

	/**
	 * Creates a file properties service loader.
	 *
	 * @param path
	 *            the properties file path.
	 */
	public FilePropertiesServiceLoader(String path) {
		this.file = path;
	}

	@Override
	@Nullable
	protected String getImplementationName(String serviceName) {
		Properties properties = new Properties();
		try (InputStream is = FilePropertiesServiceLoader.class.getResourceAsStream(this.file)) {
			if (is != null) {
				properties.load(is);
			}
		} catch (IOException e) {
			// cannot read file
		}
		return properties.getProperty(serviceName);
	}
}
