/*
 * <Java>
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.service;

/**
 * Thrown when a required service is missing.
 *
 * @see ServiceFactory#getRequiredService(Class)
 */
public class MissingServiceException extends RuntimeException {

	private static final long serialVersionUID = 1634308933004829177L;

	/**
	 * Constructs a new missing service exception with the specified detail message. The cause is not initialized, and
	 * may subsequently be initialized by a call to {@link #initCause}.
	 *
	 * @param message
	 *            the detail message (which is saved for later retrieval by the {@link #getMessage()} method).
	 */
	public MissingServiceException(String message) {
		super(message);
	}

}
