/*
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.kf;

/**
 * The listener interface for receiving notifications when a Feature is stopped by the Resource Control Manager. Object
 * instances of classes that implement this interface must be added to the Resource Control Manager listener list using
 * {@link Kernel#addResourceControlListener(ResourceControlListener)}.
 */
public interface ResourceControlListener {

	/**
	 * A stop cause. Defines the reason why the Resource Control Manager stopped a Feature.
	 */
	public enum StopCause {
		/**
		 * Stop cause for a Feature stopped when there is memory pressure.
		 *
		 * @see Feature#getCriticality()
		 */
		MEMORY,

		/**
		 * Stop cause for a Feature stopped by the watchdog.
		 */
		WATCHDOG
	}

	/**
	 * Called when a Feature is stopped by the Resource Control Manager.
	 *
	 * @param feature
	 *            the Feature that has been stopped
	 * @param cause
	 *            the stop cause
	 */
	public void featureStopped(Feature feature, StopCause cause);

}
