/*
 * Copyright 2013-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.kf;

/**
 * This exception is thrown if a Feature being loaded has already been loaded.
 *
 * @see Kernel#load(java.io.InputStream)
 */
public class AlreadyLoadedFeatureException extends Exception {

	/**
	 * Creates an {@link AlreadyLoadedFeatureException} with the previously loaded {@link Feature}.
	 *
	 * @param feature
	 *            the previously loaded {@link Feature}
	 */
	public AlreadyLoadedFeatureException(Feature feature) {
		throw new RuntimeException();
	}

	/**
	 * Returns the previously loaded {@link Feature}.
	 *
	 * @return the previously loaded {@link Feature}.
	 */
	public Feature getFeature() {
		throw new RuntimeException();
	}
}
