/*
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet.selector;

import ej.annotation.Nullable;
import ej.mwt.Widget;

/**
 * A root selector selects by checking if a widget is the root widget of its hierarchy (i.e. if it has no parent).
 * <p>
 * Equivalent to <code>:root</code> selector in CSS. Its specificity is (0,0,1,0).
 *
 * @see SelectorHelper
 */
public class RootSelector implements Selector {

	/**
	 * Root selector singleton to avoid creating several ones.
	 */
	public static final RootSelector ROOT_SELECTOR = new RootSelector();

	/**
	 * Creates a root selector.
	 */
	private RootSelector() {
	}

	@Override
	public boolean appliesToWidget(Widget widget) {
		return widget.getParent() == null;
	}

	@Override
	public int getSpecificity() {
		return SelectorHelper.getSpecificity(0, 0, 1, 0);
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		return (obj == this);
	}

	@Override
	public int hashCode() {
		return 0;
	}
}
