/*
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.motion.none;

import ej.motion.Motion;

/**
 * Represents a motion that goes directly from start to stop.
 */
public class NoMotion implements Motion {

	/**
	 * Start value.
	 */
	private final int start;
	/**
	 * Stop value.
	 */
	private final int stop;

	/**
	 * Creates a motion for a move from start to stop.
	 *
	 * @param start
	 *            the start value.
	 * @param stop
	 *            the stop value.
	 */
	public NoMotion(int start, int stop) {
		super();
		this.start = start;
		this.stop = stop;
	}

	@Override
	public long getDuration() {
		// instant
		return 0;
	}

	@Override
	public void start() {
	}

	@Override
	public boolean isFinished() {
		return true;
	}

	@Override
	public int getStartValue() {
		return this.start;
	}

	@Override
	public int getStopValue() {
		return this.stop;
	}

	@Override
	public int getCurrentValue() {
		return this.stop;
	}

	@Override
	public int getValue(long elapsed) {
		return this.stop;
	}

}
