/*
 * Java
 *
 * Copyright 2021-2022 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg;

/**
 * Represents a vector image.
 */
public class VectorImage {

	private VectorImage() {
	}

	/**
	 * Gets a vector image from a path.
	 *
	 * @param resourcePath
	 *            the path to get the image from
	 * @return a vector image
	 * @throws VectorGraphicsException
	 *             if the image could not be retrieved for any reason (see
	 *             {@link VectorGraphicsException#getErrorCode()})
	 */
	public static VectorImage getImage(String resourcePath) {
		throw new VectorGraphicsException();
	}

	/**
	 * Creates an image derived from this image, applying the given color matrix.
	 *
	 * The given matrix is a 4x5 color matrix. It is organized like that:
	 * <ul>
	 * <li>Each line is used to compute a component of the resulting color, in this order: red, green, blue, alpha.</li>
	 * <li>The four first columns are multipliers applied to a component of the initial color, in this order: red,
	 * green, blue, alpha.</li>
	 * <li>The last column is a constant value.</li>
	 * </ul>
	 * Each component is then computed like that:
	 * <code>redMultiplier x redInitialComponent + greenMultiplier x greenInitialComponent + blueMultiplier x blueInitialComponent + constant</code>
	 * Each component is clamped between 0x0 and 0xff.
	 * <p>
	 * Let A, R, G, B be the components of the initial color and the following array a color matrix:
	 *
	 * <pre>
	 * <code>
	 * { rR, rG, rB, rA, rC,
	 *   gR, gG, gB, gA, gC,
	 *   bR, bG, bB, bA, bC,
	 *   aR, aG, aB, aA, aC }
	 * </code>
	 * </pre>
	 * <p>
	 * The resulting color components are computed as:
	 *
	 * <pre>
	 * resultRed = rR * R + rG * G + rB * B + rA * A + rC
	 * resultGreen = gR * R + gG * G + gB * B + gA * A + gC
	 * resultBlue = bR * R + bG * G + bB * B + bA * A + bC
	 * resultAlpha = aR * R + aG * G + aB * B + aA * A + aC
	 * </pre>
	 *
	 * @param colorMatrix
	 *            the color matrix used to transform colors
	 * @return the filtered image
	 * @throws ArrayIndexOutOfBoundsException
	 *             if the given color matrix is shorter than 20 entries
	 * @throws VectorGraphicsException
	 *             if the image has overlapping paths and the color matrix puts a non-opaque alpha level (see
	 *             {@link VectorGraphicsException#getErrorCode()})
	 */
	public VectorImage filterImage(float[] colorMatrix) {
		throw new VectorGraphicsException();
	}

	/**
	 * Gets the width of the vector image.
	 *
	 * @return the width
	 */
	public float getWidth() {
		throw new VectorGraphicsException();
	}

	/**
	 * Gets the height of the vector image.
	 *
	 * @return the height
	 */
	public float getHeight() {
		throw new VectorGraphicsException();
	}

	/**
	 * Gets the duration of the vector image animation if the image is animated, otherwise 0.
	 *
	 * @return the duration of the animation of the vector image
	 */
	public long getDuration() {
		throw new VectorGraphicsException();
	}

}
