/*
 * Java
 *
 * Copyright 2015-2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link String}. This converter creates a clone of the
 * original {@link String}.
 */
public class StringConverter implements Converter<String> {

	@Override
	public String convert(String arg0, Feature targetOwner) throws IllegalAccessError {
		try {
			return Kernel.clone(arg0, targetOwner);
		} catch (CloneNotSupportedException e) {
			// should not occur
			throw new AssertionError();
		}
	}

	@Override
	public Class<String> getType() {
		return String.class;
	}

}