/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth.callbacks.impl;

import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.callbacks.ClientCallbacks;

/**
 * The <code>DefaultClientCallbacks</code> class provides a default implementation of the {@link ClientCallbacks}
 * interface.
 * <p>
 * The implementation of each of the methods does nothing.
 */
public class DefaultClientCallbacks implements ClientCallbacks {

	@Override
	public void onReadCompleted(BluetoothCharacteristic characteristic, int status, byte[] value) {
		throw new RuntimeException();
	}

	@Override
	public void onWriteCompleted(BluetoothCharacteristic characteristic, int status) {
		throw new RuntimeException();
	}

	@Override
	public void onNotificationReceived(BluetoothCharacteristic characteristic, byte[] value) {
		throw new RuntimeException();
	}

	@Override
	public void onReadCompleted(BluetoothDescriptor descriptor, int status, byte[] value) {
		throw new RuntimeException();
	}

	@Override
	public void onWriteCompleted(BluetoothDescriptor descriptor, int status) {
		throw new RuntimeException();
	}
}
