/*
 * Java
 *
 * Copyright 2020-2024 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 */
package org.junit;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * {@code @RepeatedTest} is used to signal that the annotated method is a
 * <em>test template</em> method that should be repeated a {@linkplain #value
 * specified number of times}.
 *
 * <p>
 * Each invocation of the repeated test behaves like the execution of a regular
 * {@link Test @Test} method with full support for the same lifecycle callbacks
 * and extensions.
 *
 * <p>
 * {@code @RepeatedTest} methods must not be {@code private} or {@code static}
 * and must return {@code void}.
 *
 * <p>
 * {@code @RepeatedTest} may also be used as a meta-annotation in order to
 * create a custom <em>composed annotation</em> that inherits the semantics of
 * {@code @RepeatedTest}.
 *
 * @since 5.0
 * @see Test
 */
@Target({ ElementType.ANNOTATION_TYPE, ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface RepeatedTest {

	/**
	 * The number of repetitions.
	 *
	 * @return the number of repetitions; must be greater than zero
	 */
	int value();
}
