/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.image.pathdata;

import java.nio.ByteBuffer;

/**
 * Decodes a path whose data is stored in only one byte array: CMD0, CMD_DATA0, CMD_DATA1, CMD1, CMD_DATA0, CMD_DATA1,
 * etc. The command and command's attributes are encoded in float or signed 8-16-32 bits.
 */
public abstract class SingleArrayPathData implements PathData {

	/**
	 * The encoded path.
	 */
	protected final ByteBuffer buffer; // used by sub-classes

	/**
	 * Creates a decoder that will decode the path encoded in a single byte array.
	 *
	 * @param buffer
	 *            the encoded path (the first available data is the first path's command)
	 */
	protected SingleArrayPathData(ByteBuffer buffer) {
		this.buffer = buffer;
	}

	@Override
	public boolean hasRemainingCommand() {
		return this.buffer.hasRemaining();
	}

}
