/*
 * Java
 *
 * Copyright 2012-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.benchmark.time;

/**
 * Defines a time strategy to get a time in nanoseconds. Default implementations
 * {@link SystemCurrentTimeStrategy} and {@link PlatformTimeStrategy} are
 * available. However the time can be retrieved by a specific native (to use a
 * hardware timer for instance).
 */
public interface TimeStrategy {

	/**
	 * Return the current time.
	 *
	 * @return a time in nanoseconds
	 */
	long getTime();
}
