/*
 * Java
 *
 * 2018-2022 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.kf;



/**
 * The listener interface for receiving notifications when a Feature is stopped by the Resource Control Manager.
 * Object instances of classes that implement this interface must be added to the Resource Control Manager listener list
 * using {@link Kernel#addResourceControlListener(ResourceControlListener)}.
 */
public interface ResourceControlListener {

	/**
	 * A stop cause. Defines the reason why the Resource Control Manager stopped a Feature.
	 */
	public enum StopCause {
		/**
		 * Stop cause for a Feature stopped when there is memory pressure.
		 * @see Feature#getCriticality()
		 */
		MEMORY,

		/**
		 * Stop cause for a Feature stopped by the watchdog.
		 */
		WATCHDOG
	}

	/**
	 * Called when a Feature is stopped by the Resource Control Manager.
	 * @param feature the Feature that has been stopped
	 * @param cause the stop cause
	 */
	public void featureStopped(Feature feature, StopCause cause);

}
