/*
 * Copyright 2015-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.style.dimension;

import ej.annotation.Nullable;
import ej.mwt.Widget;
import ej.mwt.util.Rectangle;
import ej.mwt.util.Size;

/**
 * Dimension without constraint.
 */
public final class NoDimension implements Dimension {

	/**
	 * NoDimension singleton to avoid creating several ones.
	 */
	public static final NoDimension NO_DIMENSION = new NoDimension();

	private NoDimension() {
	}

	@Override
	public void getAvailableSize(Widget widget, int availableWidth, int availableHeight, Size availableSize) {
		// Nothing to do.
	}

	@Override
	public void computeOptimalSize(Widget widget, int availableWidth, int availableHeight, Size optimalSize) {
		// Nothing to do.
	}

	@Override
	public void layOut(Widget widget, Rectangle bounds) {
		// Nothing to do.
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		return (obj == this);
	}

	@Override
	public int hashCode() {
		return 103881421;
	}
}
