/*
 * Copyright 2015-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet.selector.combinator;

import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.stylesheet.selector.Selector;

/**
 * A child combinator selects by checking the widget direct hierarchy.
 * <p>
 * Equivalent to <code>widget&gt;widget</code> selector in CSS.
 *
 * @see Widget#getParent()
 */
public class ChildCombinator extends Combinator {

	/**
	 * Creates a child combinator.
	 *
	 * @param selector1
	 *            the first selector.
	 * @param selector2
	 *            the second selector.
	 */
	public ChildCombinator(Selector selector1, Selector selector2) {
		super(selector1, selector2);
	}

	@Override
	public boolean appliesToWidget(Widget widget) {
		// check that second selector applies to widget
		if (!getSecondSelector().appliesToWidget(widget)) {
			return false;
		}

		// get parent
		Container parent = widget.getParent();
		if (parent == null) {
			return false;
		}

		// check that first selector applies to parent
		return getFirstSelector().appliesToWidget(parent);
	}
}
