/*
 * Java
 *
 * Copyright 2021-2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.microvg.test;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import ej.microvg.VectorGraphicsException;
import ej.microvg.VectorImage;

/**
 * Tests {@link VectorImage#getImage(String)} method.
 */
public class TestGetImage {

	/**
	 * Starts MicroUI.
	 */
	@BeforeClass
	public static void pre() {
		TestUtilities.startMicroUI();
	}

	/**
	 * Stops MicroUI.
	 */
	@AfterClass
	public static void post() {
		TestUtilities.stopMicroUI();
	}

	/**
	 * Tests getting an existing image.
	 */
	@Test
	public static void testExistingImage() {
		VectorImage.getImage("/com/microej/microvg/test/mascot.xml");
		Assert.assertTrue("get image", true);
	}

	/**
	 * Tests getting an existing image without leading slash.
	 */
	@Test
	public static void testImageMissingLeadingSlash() {
		boolean exception;
		try {
			VectorImage.getImage("images/mascot.xml");
			exception = false;
		} catch (VectorGraphicsException e) {
			exception = true;
		}
		Assert.assertTrue("missing leading /", exception);
	}

	/**
	 * Tests getting a not existing image.
	 */
	@Test
	public static void testImageWrongPath() {
		boolean exception;
		try {
			VectorImage.getImage("/images/themascot.xml");
			exception = false;
		} catch (VectorGraphicsException e) {
			exception = true;
		}
		Assert.assertTrue("wrong path", exception);
	}

	/**
	 * Tests getting a not existing image.
	 */
	@Test
	public static void testNotExistingImage() {
		boolean exception;
		try {
			VectorImage.getImage("bidou.xml");
			exception = false;
		} catch (VectorGraphicsException e) {
			exception = true;
		}
		Assert.assertTrue("not existing image", exception);
	}

}
