/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.event.controller;

import ej.microui.event.generator.Buttons;

/**
 * Event handler that manages {@link Buttons} events.
 * 
 * @since 2.0
 */
public interface ButtonEventHandler {

	/**
	 * Handles button pressed event.
	 *
	 * @param event
	 *            the button event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean onButtonPressed(int event);

	/**
	 * Handles button released event.
	 *
	 * @param event
	 *            the button event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean onButtonReleased(int event);

	/**
	 * Handles button clicked event.
	 *
	 * @param event
	 *            the button event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean onButtonClicked(int event);

	/**
	 * Handles button double-clicked event.
	 *
	 * @param event
	 *            the button event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean onButtonDoubleClicked(int event);

	/**
	 * Handles button repeated event.
	 *
	 * @param event
	 *            the button event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean onButtonRepeated(int event);

}
