/*
 * Java
 *
 * 2010-2020 ESR - Not subject to Copyright.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui;

/**
 * The <code>MicroUI</code> class offers basic services in the MicroUI implementation.<br>
 * MicroUI is started explicitly by calling {@link #start()}. MicroUI may also be stopped with {@link #stop()}.
 * <p>
 * MicroUI is using a dedicated thread to read the input events and to manage the display serialized event mechanism.
 * This thread is started when method {@link #start()} is called.
 * <p>
 * This internal thread can call application methods (such as event callback). All exceptions thrown during this peace
 * of code are caught and redirected to the thread uncaught exception handler
 * ({@link Thread#getUncaughtExceptionHandler()}) or to the {@link Thread#getDefaultUncaughtExceptionHandler()} when no
 * specific handler is configured. If no handler is configured, a call to {@link Exception#printStackTrace()} is
 * performed.
 */
public abstract class MicroUI {

	/**
	 * Forbidden constructor: cannot instantiate a <code>MicroUI</code> object.
	 */
	private MicroUI() {
	}

	/**
	 * Starts MicroUI.<br>
	 * It implies starting event serialization as well as rendering mechanisms.<br>
	 * This method does nothing if MicroUI is already started.<br>
	 *
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to start MicroUI.
	 */
	public static void start() {
		throw new RuntimeException();
	}

	/**
	 * Stops MicroUI.<br>
	 * It implies stopping any potential event serialization as well as rendering mechanisms.<br>
	 * This method does nothing if MicroUI is already stopped.<br>
	 *
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to stop MicroUI.
	 */
	public static void stop() {
		throw new RuntimeException();
	}

	/**
	 * Checks if MicroUI has been started.<br>
	 *
	 * @return true when MicroUI is running.
	 */
	public static boolean isStarted() {
		throw new RuntimeException();
	}

	/**
	 * Gets whether the given thread is the MicroUI thread.
	 *
	 * @param thread
	 *            the thread to check
	 *
	 * @return <code>true</code> if the given thread is the MicroUI thread, <code>false</code> otherwise.
	 * @throws MicroUIException
	 *             if MicroUI is not started
	 */
	public static boolean isUIThread(Thread thread) {
		throw new RuntimeException();
	}

	/**
	 * Gets whether the current thread is the MicroUI thread.
	 *
	 * @return <code>true</code> if the current thread is the MicroUi thread, <code>false</code> otherwise.
	 * @throws MicroUIException
	 *             if MicroUI is not started
	 */
	public static boolean isUIThread() {
		throw new RuntimeException();
	}

	/**
	 * Serializes a call event in the system event stream. When the event is processed, the <code>run()</code> method of
	 * the <code>Runnable</code> object is called.<br>
	 * Multiple call events may be requested with <code>callSerially()</code>: they will occur in the order in which
	 * they were requested (first in first out policy).<br>
	 * The call to the <code>run()</code> method of the <code>Runnable</code> object is performed asynchronously
	 * Therefore <code>callSerially()</code> will never block waiting for the <code>run()</code> method to finish.<br>
	 * The <code>run()</code> method should return quickly, as with other callback methods.<br>
	 * The <code>callSerially()</code> mechanism may be used by applications as a synchronization tool in the event
	 * stream.
	 *
	 * @param run
	 *            a <code>Runnable</code> object to call
	 * @throws MicroUIException
	 *             if MicroUI is not started
	 */
	public static void callSerially(Runnable run) {
		throw new RuntimeException();
	}
}
