/*
 * Java
 *
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.trace;

/**
 * Records the events of a group of events.
 * <p>
 * A recorder is added in the framework thanks to the service factory
 * <code>[src folder]/META-INF/services/ej.trace.Recorder</code>:
 *
 * <pre>
 * ej.xxx.XXXRecorder
 * </pre>
 *
 * where <code>XXXRecorder</code> is an implementation of this interface.
 */
public interface Recorder {

	/**
	 * Gets the name of the group that the recorder manages.
	 *
	 * @return the name that identifies the group managed by the recorder
	 */
	String getGroup();

	/**
	 * Records an event.
	 *
	 * @param eventId
	 *            the event identifier
	 * @param values
	 *            the event parameters
	 */
	void recordEvent(int eventId, int... values);

	/**
	 * Records an "end" event.
	 *
	 * @param eventId
	 *            the "end" event identifier
	 * @param values
	 *            the "end" event parameters
	 */
	void recordEventEnd(int eventId, int... values);

}
